/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  set_flg.c
 * @brief %jp{٥ȥե饰Υå}%en{Set Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_SET_FLG


/** %jp{٥ȥե饰Υå}%en{Set Eventflag}
 * @param  flgid    %jp{åоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{åȤӥåȥѥ}%en{Bit pattern to set}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(setptn)}%en{Parameter error(setptn is invalid)}
 */
ER set_flg(ID flgid, FLGPTN setptn)
{
	_KERNEL_T_QUE    *pk_que;
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_FLGINF *pk_flginf;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TCB    *tcb;
	BOOL             wupflg = FALSE;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_SET_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{ID} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ볫} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_SET_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);

	/* %jp{Ԥ} */
	pk_que = _KERNEL_FLG_GET_QUE(flgcb);
	
	/* %jp{ե饰å} */
	_KERNEL_FLG_SET_FLGPTN(flgcb, _KERNEL_FLG_GET_FLGPTN(flgcb) | setptn);

	/* %jp{Ԥеå} */
	tskhdl = _KERNEL_REF_QUE(pk_que);
	while ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);					/* %jp{TCB} */

		tskhdl_next = _KERNEL_NXT_QUE(pk_que, tskhdl);			/* %jp{Ԥ} */

		/* %jp{ե饰å} */
		pk_flginf = (_KERNEL_T_FLGINF *)_KERNEL_TSK_GET_DATA(tcb);
		if ( _kernel_chk_flg(flgcb, pk_flginf) )
		{
			/* %jp{Ƥʤ} */
			pk_flginf->waiptn = _KERNEL_FLG_GET_FLGPTN(flgcb);	/* %jp{ߤΥե饰ѥǼ} */
			
			/* %jp{Ԥ} */
			_KERNEL_TSK_SET_ERCD(tcb, E_OK);		/* %jp{顼} */
			_KERNEL_RMV_QUE(pk_que, tskhdl);		/* %jp{Ԥ󤫤곰} */
			_KERNEL_FLG_RMV_TOQ(tskhdl);			
			_KERNEL_DSP_WUP_TSK(tskhdl);			/* %jp{Ԥ} */
			
			/* %jp{Ԥȯޡ} */
			wupflg = TRUE;

#if _KERNEL_SPT_FLG_TA_CLR
			{
				const _KERNEL_T_FLGCB_RO *flgcb_ro;
				flgcb_ro = _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb);

				if ( _KERNEL_FLG_GET_FLGATR(flgcb_ro) & TA_CLR )
				{
					_KERNEL_FLG_SET_FLGPTN(flgcb, 0);			/* %jp{ꥢ°Хꥢ} */
					break;
				}
			}
#endif
		}
		tskhdl = tskhdl_next;	/* Υ˿ʤ */
	}
	
	/* ǥѥåμ¹ */
	if ( wupflg )
	{
		_KERNEL_DSP_TSK();
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return E_OK;	/*  */
}


#else	/* _KERNEL_SPT_SET_FLG */


#if _KERNEL_SPT_SET_FLG_E_NOSPT

/** %jp{٥ȥե饰Υå}%en{Set Eventflag}
 * @param  flgid    %jp{åоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{åȤӥåȥѥ}%en{Bit pattern to set}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER set_flg(ID flgid, FLGPTN setptn)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_SET_FLG */


/* end of file */
