/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wai_flg.c
 * @brief %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_WAI_FLG


#if _KERNEL_SPT_TWAI_FLG && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{twai_flgǡͥʤ} */

/** %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(waiptn, wfmode, p_flgptn)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_ILUSE  %jp{ӥѡTA_WSGL°ꤵ줿٥ȥե饰Ԥ}%en{Illegal service call use(there is already a task waiting for an eventflag with tahe TA_WSGL attribute)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥ٥ȥե饰)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return twai_flg(flgid, waiptn, wfmode, p_flgptn, TMO_FEVR);
}

#else

/** %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_CTX    %jp{ƥȥ顼}%en{Context error}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(waiptn, wfmode, p_flgptn)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_ILUSE  %jp{ӥѡTA_WSGL°ꤵ줿٥ȥե饰Ԥ}%en{Illegal service call use(there is already a task waiting for an eventflag with tahe TA_WSGL attribute)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥ٥ȥե饰)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	_KERNEL_T_FLGCB  *flgcb;
	_KERNEL_T_FLGINF flginf;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	ER               ercd;

	/* %jp{ƥȥå} */
#if _KERNEL_SPT_WAI_FLG_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		return E_CTX;			/* %jp{ƥȥ顼}%en{Context error} */
	}
#endif

	/* %jp{ID Υå} */
#if _KERNEL_SPT_WAI_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{ID} */
	}
#endif

	/* %jp{ѥ᡼Υå} */
#if _KERNEL_SPT_WAI_FLG_E_PAR
	if ( waiptn == 0 )
	{
		return E_PAR;	/* %jp{ѥ᡼} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ볫} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_WAI_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);

#if _KERNEL_SPT_WAI_FLG_E_ILUSE
	if ( !(_KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_WMUL)
			&& _KERNEL_REF_QUE(_KERNEL_FLG_GET_QUE(flgcb)) != _KERNEL_TSKHDL_NULL )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_ILUSE;
	}
#endif

	/* %jp{Ԥ} */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;
	
	/* %jp{ե饰å} */
	if ( _kernel_chk_flg(flgcb, &flginf) )
	{
		/* %jp{˾Ƥʤ} */
		if ( p_flgptn != NULL )
		{
			*p_flgptn = _KERNEL_FLG_GET_FLGPTN(flgcb);		/* %jp{Υե饰ѥǼ} */
		}
		
#if _KERNEL_SPT_FLG_TA_CLR
		if ( _KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_CLR )
		{
			_KERNEL_FLG_SET_FLGPTN(flgcb, 0);		/* %jp{ꥢ°Хꥢ} */
		}
#endif
		
		ercd = E_OK;
	}
	else
	{
		/* %jp{Ԥ֤ˤ} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);			/* %jp{TCB} */
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_WAI);
		_KERNEL_TSK_SET_TSKWAIT(tcb, _KERNEL_TTW_SEM);
		_KERNEL_TSK_SET_WOBJID(tcb, flgid);
		_KERNEL_TSK_SET_DATA(tcb, (VP_INT)&flginf);
		
		_KERNEL_DSP_WAI_TSK(tskhdl);
		_KERNEL_FLG_ADD_QUE(flgcb, _KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb), tskhdl);		/* %jp{Ԥɲ} */
		
		/* %jp{ǥѥåμ¹} */
		_KERNEL_DSP_TSK();

		/* %jp{顼ɤμ} */
		ercd = _KERNEL_TSK_GET_ERCD(tcb);

		/* %jp{Ʋ줿Τʤ} */
		if ( ercd == E_OK )
		{
			if ( p_flgptn != NULL )
			{
				*p_flgptn = flginf.waiptn;		/* %jp{Υե饰ѥǼ} */
			}
		}
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return ercd;	/*  */
}

#endif


#else	/* _KERNEL_SPT_WAI_FLG */


#if _KERNEL_SPT_WAI_FLG_E_NOSPT

/** %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return E_NOSPT;
}

#endif

#endif	/* _KERNEL_SPT_WAI_FLG */


/* end of file */
