/**
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mbx.c
 * @brief %jp{᡼ܥå(IDֹ漫ư)}%en{Create Mailbox(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mbxobj.h"



#if _KERNEL_SPT_ACRE_MBX


/** %jp{᡼ܥå(IDֹ漫ư)}%en{Create Mailbox(ID Number Automatic Assignment)}
 * @param  pk_cmbx	      %jp{᡼ܥå줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the mailbox creation information}
 * @retval %jp{}%en{positiv-value} %jp{᡼ܥåIDֹ}%en{ID number of the created mailbox}
 * @retval E_NOID  %jp{IDֹ­(ղǽʥ᡼ܥåID̵)}%en{No ID number available(there id no mailbox ID assignable)}
 * @retval E_RSATR %jp{ͽ°(mbxatr뤤ϻѤǤʤ)}%en{Reserved attribute(mbxatr is invalid or unusable)}
 */
ER_ID acre_mbx(const T_CMBX *pk_cmbx)
{
	ID    mbxid;
	ER_ID erid;
	
	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_ACRE_MBX_E_RSATR
	if ( ((pk_cmbx->mbxatr & TA_TPRI) == 0 && !_KERNEL_SPT_MBX_TA_TFIFO)
		|| ((pk_cmbx->mbxatr & TA_TPRI) != 0 && !_KERNEL_SPT_MBX_TA_TPRI)
		|| ((pk_cmbx->mbxatr & TA_MPRI) == 0 && !_KERNEL_SPT_MBX_TA_MFIFO)
		|| ((pk_cmbx->mbxatr & TA_MPRI) != 0 && !_KERNEL_SPT_MBX_TA_MPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{IDõ} */
	for ( mbxid = _KERNEL_MBX_TMAX_ID; mbxid >= _KERNEL_MBX_TMIN_ID; mbxid-- )
	{
		if ( !_KERNEL_MBX_CHECK_EXS(mbxid) )
		{
			break;
		}
	}

	/* %jp{IDõå} */
#if _KERNEL_SPT_ACRE_SEM_E_NOID
	if ( mbxid < _KERNEL_MBX_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOID;				/* %jp{IDֹ­}%en{No ID number available} */
	}
#endif
	
	/* %jp{᡼ܥå} */
	erid = (ER_ID)_kernel_cre_mbx(mbxid, pk_cmbx);
	if ( erid == E_OK )
	{
		erid = (ER_ID)mbxid;
	}

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_MBX */


#if _KERNEL_SPT_ACRE_MBX_E_NOSPT

/** %jp{᡼ܥå(IDֹ漫ư)}%en{Create Eventflag(ID Number Automatic Assignment)}
 * @param  pk_cmbx	%jp{᡼ܥå줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the eventflag creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER_ID acre_mbx(const T_CMBX *pk_cmbx)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_MBX */



/* end of file */
