/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  get_mpf.c
 * @brief %jp{Ĺס񸻤γ(ݡ)}%en{Acquired Fixed-Sized Memory Block(Poling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mpfobj.h"



#if _KERNEL_SPT_PGET_MPF


#if _KERNEL_SPT_TGET_MPF && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{tget_mpfǡͥʤ} */

/** %jp{Ĺסγ(ݡ)}%en{Acquired Fixed-Sized Memory Block(Poling)}
 * @param  mpfid	%jp{֥åоݤθĹסIDֹ}%en{ID number of the fixed-sized memory pool from which resource is acquired}
 * @param  p_blkf	%jp{Ĺס줿ѥåȤؤΥݥ}%en{Start address of the acquired memory block}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mpfid뤤ϻѤǤʤ)}%en{Invalid ID number(mpfid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݸĹס뤬̤Ͽ)}%en{Non-existant object(specified fixed-sized memory pool is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(p_blk, tmout)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤˸Ĺס뤬)}%en{Waiting object deleted(fixed-sized memory pool is deleted waiting)}
 */
ER pget_mpf(ID mpfid, VP *p_blk)
{
	/* %jp{tget_mpfؤ} */
	return tget_mpf(mpfid, p_blk, TMO_POL);
}

#else


/** %jp{Ĺסγ(ݡ)}%en{Acquired Fixed-Sized Memory Block(Poling)}
 * @param  mpfid	%jp{֥åоݤθĹסIDֹ}%en{ID number of the fixed-sized memory pool from which resource is acquired}
 * @param  p_blkf	%jp{Ĺס줿ѥåȤؤΥݥ}%en{Start address of the acquired memory block}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mpfid뤤ϻѤǤʤ)}%en{Invalid ID number(mpfid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݸĹס뤬̤Ͽ)}%en{Non-existant object(specified fixed-sized memory pool is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(p_blk, tmout)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤˸Ĺס뤬)}%en{Waiting object deleted(fixed-sized memory pool is deleted waiting)}
 */
ER pget_mpf(ID mpfid, VP *p_blk)
{
	_KERNEL_T_MPFCB_PTR  mpfcb;
	_KERNEL_MPF_T_BLKHDL blkhdl;
	VP                   blkptr;
	ER                   ercd;
	
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_PGET_MPF_E_ID
	if ( !_KERNEL_MPF_CHECK_MPFID(mpfid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_PGET_MPF_E_NOEXS
	if ( !_KERNEL_MPF_CHECK_EXS(mpfid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ȥ֥å} */
	mpfcb = _KERNEL_MPF_ID2MPFCB(mpfid);
	
	/* %jp{Ĺס륫󥿼} */
	blkhdl = _KERNEL_MPF_GET_FREBLK(mpfcb);
	
	if ( blkhdl != _KERNEL_MPF_BLKHDL_NULL )
	{
		/* %jp{Ĺס񸻤Ǥ} */
		blkptr = _KERNEL_MPF_BLKHDL2PTR(mpfcb, blkhdl);
		*p_blk = blkptr;
		_KERNEL_MPF_SET_FREBLK(mpfcb, *(_KERNEL_MPF_T_BLKHDL *)blkptr);
		_KERNEL_MPF_SET_FBLKCNT(mpfcb, _KERNEL_MPF_GET_FBLKCNT(mpfhdl) - 1);
		ercd = E_OK;
	}
	else
	{
		ercd = E_TMOUT;
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{֥̤}%en{Non-existant object} */
	
	return ercd;
}

#endif


#else	/* _KERNEL_SPT_PGET_MPF */


#if _KERNEL_SPT_PGET_MPF_E_NOSPT

/** %jp{Ĺסγ(ݡ)}%en{Acquired Fixed-Sized Memory Block(Poling)}
 * @param  mpfid	%jp{֥åоݤθĹסIDֹ}%en{ID number of the fixed-sized memory pool from which resource is acquired}
 * @param  p_blkf	%jp{Ĺס줿ѥåȤؤΥݥ}%en{Start address of the acquired memory block}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER pget_mpf(ID mpfid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_PGET_MPF */



/* end of file */
