/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  get_mpf.c
 * @brief %jp{Ĺס񸻤γ}%en{Acquire Semaphore Resource}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mpfobj.h"



#if _KERNEL_SPT_GET_MPF


#if _KERNEL_SPT_TGET_MPF && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{tget_mpfǡͥʤ} */


ER get_mpf(ID mpfid, VP *p_blk)
{
	/* %jp{tget_mpfؤ} */
	return tget_mpf(mpfid, p_blk, TMO_FEVR);
}

#else


ER rel_mpf(ID mpfid, VP blk)
{
	_KERNEL_T_MPFCB_PTR mpfcb;
	_KERNEL_T_TSKHDL    tskhdl;
	_KERNEL_T_TCB       *tcb;

	/* %jp{ƥȥå} */
#if _KERNEL_SPT_GET_MPF_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_CTX;			/* %jp{ƥȥ顼}%en{Context error} */
	}
#endif
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_GET_MPF_E_ID
	if ( !_KERNEL_MPF_CHECK_MPFID(mpfid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_GET_MPF_E_NOEXS
	if ( !_KERNEL_MPF_CHECK_EXS(mpfid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ȥ֥å} */
	mpfcb = _KERNEL_MPF_ID2MPFCB(mpfid);

	/* %jp{ԤƬ饿Ф} */
	tskhdl = _KERNEL_MPF_RMH_QUE(mpfcb);
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		VP *p_blk;

		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		p_blk = (VP *)_KERNEL_TSK_GET_DATA(tcb);
		*p_blk = blk;
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);			/* %jp{顼} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{Ԥ} */
		_KERNEL_MPF_RMV_TOQ(tskhdl);
		
		/* %jp{ǥѥåμ¹} */
		_KERNEL_DSP_TSK();
	}
	else
	{
		/* %jp{סֵ} */
		*(_KERNEL_MPF_T_BLKHDL *)blk = _KERNEL_MPF_GET_FREBLK(mpfcb);
		_KERNEL_MPF_SET_FREBLK(mpfcb, _KERNEL_MPF_PTR2BLKHDL(mpfcb, blk));
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}

#endif


#else	/* _KERNEL_SPT_GET_MPF */


#if _KERNEL_SPT_GET_MPF_E_NOSPT


ER get_mpf(ID mpfid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_GET_MPF */



/* end of file */
