/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_sem.c
 * @brief %en{Activate Task}%jp{εư}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/semobj.h"


/* %jp{­顼åݡȤȽ} */
#if (_KERNEL_SPT_CRE_SEM && _KERNEL_SPT_CRE_SEM_E_NOMEM) || (_KERNEL_SPT_ACRE_SEM && _KERNEL_SPT_ACRE_SEM_E_NOMEM)
#define _KERNEL_SPT_KCRE_SEM_E_NOMEM	TRUE
#else
#define _KERNEL_SPT_KCRE_SEM_E_NOMEM	FALSE
#endif



/** %jp{ޥե}%en{Create semaphore}
 * @param  semid	%jp{оݤΥޥեIDֹ}%en{ID number of the semaphore to be created}
 * @param  pk_ctsk	%jp{ޥե줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_NOMEM  %jp{­}%en{Insufficient memory}
 */
ER _kernel_cre_sem(ID semid, const T_CSEM *pk_csem)
{
	_KERNEL_T_SEMCB    *semcb;
	_KERNEL_T_SEMCB_RO *semcb_ro;
	
	/* %jp{}%en{get memory} */
#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_BLKARRAY
	{
		semcb    = _KERNEL_SEM_ID2SEMCB(semid);
		semcb_ro = semcb;
	}
#elif _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY
#if _KERNEL_SEMCB_SPLIT_RO
	{
		/* %jp{SEMCBΰ褬ݥ󥿴ǡROM/RAMʬΥξ} */
		VP   mem;
		SIZE memsz;

		/* %jp{ꥵ} */
		memsz = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_SEMCB))
					+ _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_SEMCB_RO));

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_SEM_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif
		
		/* %jp{} */
		semcb    = (_KERNEL_T_SEMCB *)mem;
		semcb_ro = (_KERNEL_T_SEMCB_RO *)((VB *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_SEMCB)));
		_KERNEL_SEM_ID2SEMCB(semid)           = semcb;
		_KERNEL_SEM_ID2SEMCB(semid)->semcb_ro = (const _KERNEL_T_SEMCB_RO *)semcb_ro;
	}
#else
	{
		VP   mem;
		
		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(sizeof(_KERNEL_T_SEMCB));

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_SEM_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif

		/* %jp{} */
		semcb    = (_KERNEL_T_SEMCB *)mem;
		semcb_ro = (_KERNEL_T_SEMCB_RO *)mem;
		_KERNEL_SEM_ID2SEMCB(semid) = semcb;
	}
#endif
#endif

	/* %jp{н} */
	_KERNEL_CRE_QUE(_KERNEL_SEM_GET_QUE(semcb));
	_KERNEL_SEM_SET_SEMCNT(semcb, pk_csem->isemcnt);
	_KERNEL_SEM_SET_SEMATR(semcb_ro, pk_csem->sematr);
	_KERNEL_SEM_SET_MAXSEM(semcb_ro, pk_csem->maxsem);
	
	return E_OK;
}


/* end of file */
