/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_tsk.c
 * @brief %jp{(IDֹ漫ưդ)}%en{Create Task(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


#if _KERNEL_SPT_ACRE_TSK


/** %jp{}%en{Create Task}
 * @param  tskid	%jp{ID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the task creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_NOID   %jp{IDֹ­}%en{No ID number available}
 * @retval E_NOMEM	%jp{­}%en{Insufficient memory}
 * @retval E_PAR    %jp{ѥ᡼顼}%en{Perameter error}
 * @retval E_RSATR  %jp{ͽ°(tskatr뤤ϻѤǤʤ)}%en{Reserved attribute(tskatr is invalid or unusable)}
 */
ER_ID acre_tsk(
		const T_CTSK *pk_ctsk)
{
	ID    tskid;
	ER_ID erid;

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{IDõ} */
#if _KERNEL_ACRE_TSK_ASCENDING_ORDER
	/* %jp{IDõ} */
	for ( tskid = _KERNEL_TSK_TMIN_ID; tskid <= _KERNEL_TSK_TMAX_ID; tskid++ )
	{
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			break;
		}
	}
	if ( tskid > _KERNEL_TSK_TMAX_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOID;				/* %jp{IDֹ­}%en{No ID number available} */
	}
#else
	/* %jp{ID߽õ} */
	for ( tskid = _KERNEL_TSK_TMAX_ID; tskid >= _KERNEL_TSK_TMIN_ID; tskid-- )
	{
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			break;
		}
	}
	if ( tskid < _KERNEL_TSK_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOID;				/* %jp{IDֹ­}%en{No ID number available} */
	}
#endif
	
	/* %jp{} */
	erid = (ER_ID)_kernel_cre_tsk(tskid, pk_ctsk);
	if ( erid == E_OK )
	{
		erid = (ER_ID)tskid;
	}
	
	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return erid;
}



#else	/* _KERNEL_SPT_ACRE_TSK */


#if _KERNEL_SPT_ACRE_TSK_E_NOSPT

/** %jp{}%en{Create Task}
 * @param  tskid	%jp{ID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the task creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER acre_tsk(
		const T_CTSK	*pk_ctsk)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_TSK */


/* end of file */
