/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  act_tsk.c
 * @brief %jp{εư}%en{Activate Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



#if _KERNEL_SPT_ACT_TSK


/** %jp{εư}%en{Activate Task}
 * @param  tskid    %jp{ưоݤΥIDֹ}%en{ID number of the task to be activated}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(tskid뤤ϻѤǤʤ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ̤Ͽ)}%en{Non-existant object(specified task is not registerd)}
 * @retval E_QOVR   %jp{塼󥰥Сե(ư׵ᥭ塼󥰤ΥСե)}%en{Queue overflow(overflow of activate queuing count)}
 */
ER act_tsk(
		ID tskid)
{
	_KERNEL_T_TSKHDL		tskhdl;
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TCB_RO_PTR	tcb_ro;

	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
#if _KERNEL_SPT_ACT_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif	
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	}
	else
	{
#if _KERNEL_SPT_ACT_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_ACT_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;			/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) != _KERNEL_TTS_DMT )		/* %jp{֥ȾȽ} */
	{
#if _KERNEL_TCB_ACTCNT
		{
			_KERNEL_TSK_T_ACTCNT actcnt;

			/* %jp{˼¹Ծ֤ʤ鵯ư׵򥭥塼} */
			actcnt = _KERNEL_TSK_GET_ACTCNT(tcb);
		
			/* %jp{˼¹Ծ֤ʤ鵯ư׵򥭥塼} */
		#ifdef _KERNEL_CFG_ACT_TSK_E_QOVR
			if ( actcnt >= _KERNEL_TMAX_ACTCNT )
			{
				_KERNEL_LEAVE_SVC();
				return E_QOVR;		/* %jp{塼󥰥Сե} */
			}
		#endif

			/* %jp{ư׵򥭥塼} */
			_KERNEL_TSK_SET_ACTCNT(tcb, actcnt + 1);
		}
#else
		{
			_KERNEL_LEAVE_SVC();
			return E_QOVR;		/* %jp{塼󥰥Сե} */
		}
#endif
	}
	else
	{
		/* %jp{ֽ} */
		tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
		_KERNEL_TSK_SET_TSKPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
		_KERNEL_TSK_SET_TSKBPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_RDY);
		_KERNEL_TSK_SET_ACTCNT(tcb, 0);
		_KERNEL_TSK_SET_WUPCNT(tcb, 0);
		_KERNEL_TSK_SET_SUSCNT(tcb, 0);
		
		/* %jp{ƥ} */
		_KERNEL_CRE_CTX(
				_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ƥ֥å} */
				_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{Υåΰ襵} */
				_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{ΥåΰƬ} */
				(VP)_KERNEL_TSK_GET_ISP(tcb_ro),			/* %jp{åݥ󥿤ν} */
				(FP)_kernel_ent_tsk,						/* %jp{ƥȤγϥɥ쥹} */
				(VP_INT)_KERNEL_TSK_GET_EXINF(tcb_ro),		/* %jp{γĥ} */
				(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{εư} */
			);
		
		/* %jp{¹Բǽ֤} */
		_KERNEL_DSP_STA_TSK(tskhdl);
		
		/* %jp{ǥѥåμ¹}%en{task dispatch} */
		_KERNEL_DSP_TSK();
	}
	
	_KERNEL_LEAVE_SVC();
	
	return E_OK;	/*  */
}


#else	/* _KERNEL_SPT_ACT_TSK */


/** %en{Activate Task}%jp{εư}
 * @param  tskid    %jp{ưоݤΥIDֹ}%en{ID number of the task to be activated}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER act_tsk(
		ID tskid)
{
	return E_NOSPT;
}

#endif	/* _KERNEL_SPT_ACT_TSK */


/* end of file */
