/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wup_tsk.c
 * @brief %jp{ε}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



ER can_wup(
		ID tskid)
{
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
#if _KERNEL_SPT_CAN_WUP_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif	
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	}
	else
	{
#if _KERNEL_SPT_CAN_WUP_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_CAN_WUP_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;			/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	
	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{Ԥ󥿥ꥢ} */
	_KERNEL_TSK_SET_WUPCNT(tcb, 0);


	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */

	return E_OK;
}


/* end of file */
