/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_tsk.c
 * @brief %jp{}%en{Create Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_CRE_TSK


/** %jp{}%en{Create Task}
 * @param  tskid	%jp{ID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the task creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(tskid뤤ϻѤǤʤ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOMEM	%jp{­}%en{Insufficient memory}
 * @retval E_PAR    %jp{ѥ᡼顼}%en{Perameter error}
 * @retval E_RSATR  %jp{ͽ°(tskatr뤤ϻѤǤʤ)}%en{Reserved attribute(tskatr is invalid or unusable)}
 */
ER cre_tsk(
		ID				tskid,
		const T_CTSK	*pk_ctsk)
{
	ER ercd;

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_TSK_E_ID
	if ( _KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;				/* %jp{IDֹ­} */
	}
#endif
	
	/* %jp{} */
	ercd = _kernel_cre_tsk(tskid, pk_ctsk);

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;	/*  */
}


#else	/* _KERNEL_SPT_CRE_TSK */


#if _KERNEL_SPT_CRE_TSK_E_NOSPT

/** %jp{}%en{Create Task}
 * @param  tskid	%jp{ID}%en{ID number of the task to be created}
 * @param  pk_ctsk	%jp{줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the task creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER cre_tsk(
		ID				tskid,
		const T_CTSK	*pk_ctsk)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_TSK */



/* end of file */
