/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_tsk.c
 * @brief %jp{κ}%en{Delete Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/tskobj.h"



#if _KERNEL_SPT_DEL_TSK


/** %jp{κ}%en{Delete Task}
 * @param  tskid    %jp{оݤΥIDֹ}%en{ID number of the task to be deleted}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(tskid뤤ϻѤǤʤ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ̤Ͽ)}%en{Non-existant object(specified task is not registerd)}
 */
ER del_tsk(ID tskid)
{
	_KERNEL_T_TCB_PTR	tcb;
	
	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_DEL_TSK_E_ID
	if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
	{
		return E_ID;			/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_DEL_TSK_E_NOEXS
	if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;
	}
#endif
	
	/* %jp{ȥ֥å} */
	tcb = _KERNEL_TSK_ID2TCB(tskid);
	
#if _KERNEL_SPT_DEL_TSK_E_OBJ
	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) != _KERNEL_TTS_DMT )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;
	}
#endif
	
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(tcb);			/* %jp{곫} */
	_KERNEL_TSK_ID2TCB(tskid) = NULL;
#elif _KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_BLKARRAY
	_KERNEL_TSK_SET_TASK(tcb, 0);
#endif
	
	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_TSK */


#if _KERNEL_SPT_DEL_TSK_E_NOSPT

/** %jp{κ}%en{Delete Task}
 * @param  tskid    %jp{оݤΥIDֹ}%en{ID number of the task to be deleted}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER del_tsk(ID tskid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_TSK */



/* end of file */
