/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  chg_pri.c
 * @brief %jp{ͥ٤ѹ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/** %jp{ͥ٤λ} */
ER get_pri(ID tskid, PRI *p_tskpri)
{
	_KERNEL_T_TSKHDL   tskhdl;
	_KERNEL_T_TCB_PTR  tcb;

	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{

#if _KERNEL_SPT_REF_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif	
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */

		/* %jp{TCB} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	}
	else
	{
#if _KERNEL_SPT_REF_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_REF_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;				/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tcb    = _KERNEL_TSK_ID2TCB(tskid);
		tskhdl = _KERNEL_TSK_GET_TSKHDL(tskid, tcb);
	}
	
	/* %jp{ͥټ} */
	*p_tskpri = _KERNEL_TSK_GET_TSKBPRI(tcb);

	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */

	return E_OK;
}


/* end of file */
