/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kcre_tsk.c
 * @brief %en{Activate Task}%jp{εư}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/** %en{Activate Task}%jp{εư}
 * @param  tskid	%jp{ID}%en{ID number of the task to be activated}
 * @param  pk_ctsk	%jp{}%en{}
 * @retval E_OK
 * @retval E_NOMEM
 */
ER _kernel_cre_tsk(ID tskid, const T_CTSK *pk_ctsk)
{
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB_RO *tcb_ro;
	VP               stk;
	
	/* %jp{}%en{get memory} */
#if	_KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_BLKARRAY
	{
		/* %jp{TCBΰ褬֥åξ硢åΤ߳} */

		/* %jp{åγ} */
		if ( pk_ctsk->stk == NULL )
		{
			stk = _KERNEL_SYS_ALC_HEP(pk_ctsk->stksz);
			if ( stk == NULL )
			{
				return E_NOMEM;
			}
		}
		else
		{
			stk = pk_ctsk->stk;
		}
		
		tcb    = _KERNEL_TSK_ID2TCB(tskid);
		tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
	}
#elif _KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_PTRARRAY
#if _KERNEL_TCB_SPLIT_RO
	{
		/* %jp{TCBΰ褬ݥ󥿴ǡROM/RAMʬΥξ} */

		VP   mem;
		SIZE memsz;

		/* %jp{ꥵ} */
		memsz = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB))
					+ _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB_RO));
		if ( pk_ctsk->stk == NULL )
		{
			memsz += pk_ctsk->stksz;
		}

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);
		if ( mem == NULL )
		{
			return E_NOMEM;
		}

		/* %jp{} */
		_KERNEL_TSK_ID2TCB(tskid) = tcb    = (_KERNEL_T_TCB *)mem;
		tcb->tcb_ro               = tcb_ro = (_KERNEL_T_TCB_RO *)((B *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB)));
		if ( pk_ctsk->stk == NULL )
		{
			stk = (VP)((B *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB)) + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB_RO)));
		}
		else
		{
			stk = pk_ctsk->stk;
		}
	}
#else
	{
		VP   mem;
		SIZE memsz;
		
		/* %jp{ꥵ} */
		memsz = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB));
		if ( pk_ctsk->stk == NULL )
		{
			memsz += pk_ctsk->stksz;
		}

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);
		if ( mem == NULL )
		{
			return E_NOMEM;
		}

		/* %jp{} */
		_KERNEL_TSK_ID2TCB(tskid) = tcb_ro = tcb = (_KERNEL_T_TCB *)mem;
		if ( pk_ctsk->stk == NULL )
		{
			stk = (VP)((VB *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_TCB)));
		}
		else
		{
			stk = pk_ctsk->stk;
		}
	}
#endif
#endif
	
	/* %jp{ܥ} */
	_KERNEL_TSK_SET_TSKATR(tcb_ro, pk_ctsk->tskatr);			/* %jp{°} */
	_KERNEL_TSK_SET_EXINF(tcb_ro, pk_ctsk->exinf);				/* %jp{γĥ} */
	_KERNEL_TSK_SET_TASK(tcb_ro, pk_ctsk->task);				/* %jp{εư} */
	_KERNEL_TSK_SET_ITSKPRI(tcb_ro, pk_ctsk->itskpri);			/* %jp{εưͥ} */
	_KERNEL_TSK_SET_STKSZ(tcb_ro, pk_ctsk->stksz);				/* %jp{åΰΥ(Хȿ)} */
	_KERNEL_TSK_SET_STK(tcb_ro, stk);							/* %jp{åΰƬ} */
	_KERNEL_TSK_SET_ISP(tcb_ro, (VB *)stk + pk_ctsk->stksz);	/* %jp{åݥ󥿽ͤƬ} */
	_KERNEL_TSK_SET_TSKID(tcb_ro, tskid);
	_KERNEL_TSK_SET_TEXATR(tcb_ro, TA_HLNG);
	_KERNEL_TSK_SET_TEXRTN(tcb_ro, NULL);
	
	_KERNEL_TSK_CRE_TOQOBJ(tcb);
	_KERNEL_TSK_CRE_QUEOBJ(tcb);
	_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_DMT);
	_KERNEL_TSK_SET_MTXHDL(tcb, _KERNEL_MTXHDL_NULL);
	_KERNEL_TSK_SET_TEXSTAT(tcb, _KERNEL_TXS_DIS);
	_KERNEL_TSK_SET_RASPTN(tcb, 0);

	/* %jp{TA_ACT°Х¹} */
#if _KERNEL_SPT_TSK_TA_ACT
	if ( pk_ctsk->tskatr & TA_ACT )
	{
		/* %jp{ֽ} */
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_RDY);
		_KERNEL_TSK_SET_TSKPRI(tcb, pk_ctsk->itskpri);
		_KERNEL_TSK_SET_TSKBPRI(tcb, pk_ctsk->itskpri);
		_KERNEL_TSK_SET_ACTCNT(tcb, 0);
		_KERNEL_TSK_SET_WUPCNT(tcb, 0);
		_KERNEL_TSK_SET_SUSCNT(tcb, 0);
		
		/* %jp{ƥ} */
		_KERNEL_CRE_CTX(
				_KERNEL_TSK_GET_CTXCB(tcb),			/* %jp{ƥ֥å} */
				pk_ctsk->tsksz,						/* %jp{Υåΰ襵} */
				stk,								/* %jp{ΥåΰƬ} */
				(VP)((VB *)stk + pk_ctsk->stksz),	/* %jp{åݥ󥿤ν} */
				(FP)_kernel_ent_tsk,				/* %jp{ƥȤγϥɥ쥹} */
				(VP_INT)pk_ctsk->exinf,				/* %jp{γĥ} */
				(VP_INT)pk_ctsk->task				/* %jp{εư} */
			);
		
		/* %jp{¹Բǽ֤} */
		_KERNEL_DSP_STA_TSK(_KERNEL_TSK_GET_TSKHDL(tskid, tcb));
		
		/* %jp{ǥѥåμ¹}%en{task dispatch} */
		_KERNEL_DSP_TSK();
	}
#endif

	return E_OK;
}


/* end of file */
