/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wup_tsk.c
 * @brief %jp{ε}%en{Wakeup Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/* ξֻ */
ER ref_tsk(ID tskid, T_RTSK *p_rtsk)
{
	_KERNEL_T_TSKHDL		tskhdl;
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TCB_RO_PTR	tcb_ro;

	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
#if _KERNEL_SPT_REF_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif	
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	}
	else
	{
#if _KERNEL_SPT_REF_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_REF_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;				/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}

	/* %jp{TCB} */
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
	
	p_rtsk->tskstat = _KERNEL_DEC_TTS(_KERNEL_TSK_GET_TSKSTAT(tcb));	/* %jp{} */
	p_rtsk->tskpri  = _KERNEL_TSK_GET_TSKPRI(tcb);						/* %jp{θͥ} */
	p_rtsk->tskbpri = _KERNEL_TSK_GET_TSKBPRI(tcb);						/* %jp{Υ١ͥ} */
	p_rtsk->tskwait = _KERNEL_DEC_TTW(_KERNEL_TSK_GET_TSKWAIT(tcb));	/* %jp{Ԥװ} */
	p_rtsk->wobjid  = _KERNEL_TSK_GET_WOBJID(tcb);						/* %jp{ԤоݤΥ֥ȤIDֹ} */
/*	p_rtsk->lefttmo = _KERNEL_TSK_GET_LEFTTMO(tskhdl);	*/				/* %jp{ॢȤޤǤλ} */
	p_rtsk->actcnt  = _KERNEL_TSK_GET_ACTCNT(tcb);						/* %jp{ư׵ᥭ塼󥰲} */
	p_rtsk->wupcnt  = _KERNEL_TSK_GET_WUPCNT(tcb);						/* %jp{׵ᥭ塼󥰲} */
	p_rtsk->suscnt  = _KERNEL_TSK_GET_SUSCNT(tcb);						/* %jp{Ԥ׵ͥȲ} */
	
	
	/* %jp{ʲȼ}%en{HOS extention} */
#if _KERNEL_SPT_RTSK_TSKATR
	p_rtsk->tskatr  = _KERNEL_TSK_GET_TSKATR(tcb_ro);					/* %jp{°(HOSȼĥ)} */
#endif

#if _KERNEL_SPT_RTSK_EXINF
	p_rtsk->exinf   = _KERNEL_TSK_GET_EXINF(tcb_ro);					/* %jp{γĥ(HOSȼĥ)} */
#endif

#if _KERNEL_SPT_RTSK_TASK
	p_rtsk->task    = _KERNEL_TSK_GET_TASK(tcb_ro);						/* %jp{εư(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_ITSKPRI
	p_rtsk->itskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);					/* %jp{εưͥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_STKSZ
	p_rtsk->stksz   = _KERNEL_TSK_GET_STKSZ(tcb_ro);					/* %jp{åΰΥ(Хȿ)(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTSK_STK
	p_rtsk->stk     = _KERNEL_TSK_GET_STK(tcb_ro);						/* %jp{åΰƬ(HOSȼĥ)} */
#endif


	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */

	return E_OK;
}


/* end of file */
