# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------

# %jp{å̾}
TARGET ?= sample

# %jp{ġ}
GCC_ARCH   ?= arm-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ǥ쥯ȥ}
OS_DIR            = ../../../..
KERNEL_DIR        = $(OS_DIR)/kernel
KERNEL_CFGRTR_DIR = $(OS_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/arm/aduc7000/gcc
OBJS_DIR          = objs_$(TARGET)

# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc

# ǥХåǤΥå̾ѹ
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
endif

# 󥫥ץ
LINK_SCRIPT = link.x


# %jp{ե饰}
CFLAGS  = -mcpu=arm7tdmi -mthumb-interwork
AFLAGS  = -mcpu=arm7tdmi -mthumb-interwork
LNFLAGS = -mcpu=arm7tdmi -mthumb-interwork -nostartfiles -Wl,-Map,$(TARGET).map,-T$(LINK_SCRIPT)


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-aduc7000

# ϥե̾
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)
TARGET_HEX = $(TARGET).$(EXT_HEX)


# %jp{gccѤɹ}
include $(KERNEL_MAKINC_DIR)/gcc_d.inc

# ǥ쥯ȥ
SRC_DIRS += . ..

# ֥եɲ
ASRCS += ./vectors.S		\
         ./crt0.S

# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../sample.c		\
         ../ostimer.c		\
         ../uart.c



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: makeexe_all $(TARGET_EXE) $(TARGET_MOT) $(TARGET_HEX)

clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{gccѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/gcc_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

