/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS}%en{OS timer}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"



void OsTimer_Isr(VP_INT exinf);	/**< %jp{޳ߥӥ롼} */

extern VP _kernel_inh_tbl[224];

/** %jp{OSѥ޽롼} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_CISR cisr;
	
	/* %jp{ߥӥ롼} */
	cisr.isratr = TA_HLNG;
	cisr.exinf  = 0;
	cisr.intno  = 0;
	cisr.isr    = (FP)OsTimer_Isr;
	acre_isr(&cisr);
	
	/* %jp{ư} */
	_kernel_outpb(0x43, 0x34);
	_kernel_outpb(0x40, 0x9c);	/* 11932 = 0x2e9c */
	_kernel_outpb(0x40, 0x2e);
	
	/* %jp{ߵ} */
	ena_int(0);
}


/** %jp{޳ߥϥɥ} */
void OsTimer_Isr(VP_INT exinf)
{
	/* %jp{ƥå} */
	isig_tim();
}


/* end of file */
