# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for sh2-sample
#
# Copyright (C) 1998-2010 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{å̾}
TARGET ?= sample


# %jp{ġ}
GCC_ARCH   ?= sh-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= sh2
ARCH_CC   ?= gcc


# %jp{ǥ쥯ȥ}
TOP_DIR           = ../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/sh/sh2/gcc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-$(ARCH_NAME)


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{󥫥ץ}%en{linker script}
LINK_SCRIPT = rom.lds


ifeq ($(MEMMAP),ram)
# %jp{RAM¹(˥ץѤ)}
LINK_SCRIPT = ram.lds
TARGET     := $(TARGET)_ram
endif


# %jp{ѥ}%en{add source directories}
INC_DIRS += . ..
SRC_DIRS += . ..


# %jp{ץե饰}%en{option flags}
CFLAGS  = -m2
AFLAGS  = -m2
LNFLAGS = -m2 -nostartfiles -Wl,-Map,$(TARGET).map,-T$(LINK_SCRIPT)


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{¹ԥեɹ}%en{definitions for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_d.inc


# %jp{ϥե̾}%en{output files}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)
TARGETS    = $(TARGET_EXE) $(TARGET_MOT)


# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------


# %jp{֥եɲ}%en{assembry sources}
ASRCS += ./vector.S
ASRCS += ./crt0.S

# %jp{Cեɲ}%en{C sources}
CSRCS += ../kernel_cfg.c
CSRCS += ../main.c
CSRCS += ../sample.c
CSRCS += ../ostimer.c
CSRCS += ../sci1.c


# %jp{о}
#LINK_RENESASSCI = Yes



# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
.PHONY : all
all: kernel_make makeexe_all $(TARGETS)

# %jp{꡼}%en{clean}
.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGETS) $(OBJS) ../kernel_cfg.c ../kernel_id.h

# %jp{¸ط}%en{depend}
.PHONY : depend
depend: makeexe_depend


# %jp{ͥ뤴ȥ꡼}%en{mostlyclean}
.PHONY : mostlyclean
mostlyclean: clean kernel_clean


# %jp{ե졼¹}%en{configurator}
../kernel_cfg.c ../kernel_id.h: ../system.cfg $(KERNEL_CFGRTR)
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h



# %jp{¹ԥեɹ}%en{rules for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

