# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for sh2-sample
#
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{å̾}%en{target name}
TARGET ?= sample


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= sh2
ARCH_CC   ?= shc


# %jp{ǥ쥯ȥ}%en{directories}
OS_DIR            = ../../../..
KERNEL_DIR        = $(OS_DIR)/kernel
KERNEL_CFGRTR_DIR = $(OS_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/sh/sh2/shc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-$(ARCH_NAME)


# %jp{ɹ}%jp{common setting}
include $(KERNEL_MAKINC_DIR)/common.inc


ifeq ($(MEMMAP),ram)
# %jp{RAM¹(˥ץѤ)}%en{external RAM}
TARGET := $(TARGET)_ram
SECTION_VECT ?= 0FFFFE160
SECTION_ROM  ?= 000400400
SECTION_RAM  ?= 000410000
else
# %jp{ROMƤ}%en{internal ROM}
TARGET := $(TARGET)
SECTION_VECT ?= 000000000
SECTION_ROM  ?= 000000400
SECTION_RAM  ?= 0FFFFE000
endif


# %jp{ѥ}%en{add source directories}
INC_DIRS += . ..
SRC_DIRS += . ..


# %jp{ץե饰}%en{option flags}
AFLAGS  = -CPu=sh2
CFLAGS  = -CPu=sh2
LNFLAGS = 


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{¹ԥեɹ}%en{definitions for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_d.inc


# %jp{ϥե̾}%en{output files}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)

# %jp{C饤֥̾λ}%en{std library}
STD_LIBS = stdlib.lib




# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}
ASRCS += ./vcttbl.src
ASRCS += ./startup.src


# %jp{Cեɲ}%en{C sources}
CSRCS += ./dbsct.c
CSRCS += ../kernel_cfg.c
CSRCS += ../main.c
CSRCS += ../sample.c
CSRCS += ../ostimer.c
CSRCS += ../sci1.c


# %jp{饤֥ɲ}%en{library}
LIBS  += $(STD_LIBS)




# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
.PHONY : all
all: makeexe_all $(TARGET_EXE) $(TARGET_MOT)

# %jp{꡼}%en{clean}
.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

# %jp{¸ط}%en{depend}
.PHONY : depend
depend: makeexe_depend

# %jp{祳ԡ}%en{source files copy}
.PHONY : srccpy
srccpy: makeexe_srccpy

# %jp{ͥ뤴ȥ꡼}%en{mostlyclean}
.PHONY : mostlyclean
mostlyclean: clean kernel_clean


# %jp{ɸ饤֥}%en{std library}
$(STD_LIBS):
	lbgsh -OUTPut=$(STD_LIBS) -CPu=sh2 -REent


# %jp{ե졼¹}%en{configurator}
../kernel_cfg.c ../kernel_id.h: ../system.cfg $(KERNEL_CFGRTR)
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{¹ԥեɹ}%en{setting for execute file}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{shcѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/shc_r.inc



# --------------------------------------
#  %jp{¸ط}%en{dependency}
# --------------------------------------

$(OBJS_DIR)/sample.obj: ../sample.c ../kernel_id.h


# end of file

