# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 1998-2008 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{å̾}%en{target name}
TARGET = sample


# %jp{ƥ}%en{architecture}
ARCH_NAME = win32
ARCH_CC   = msc


# %jp{ǥ쥯ȥ}%en{directories}
TOP_DIR           = ..\..\..\..
KERNEL_DIR        = $(TOP_DIR)\kernel
KERNEL_CFGRTR_DIR = $(TOP_DIR)\cfgrtr\build\msc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)\build\common\nmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)\build\win\win32\msc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)\h4acfg-$(ARCH_NAME)


# %jp{ɹ}%jp{common setting}
!include $(KERNEL_MAKINC_DIR)\common.inc


# %jp{ѥ}%en{add source directories}
INC_DIRS = . ..
SRC_DIRS = . ..


# %jp{ץե饰}%en{option flags}
AFLAGS   = 
CFLAGS   = 
LNFLAGS  = 


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
!include $(KERNEL_MAKINC_DIR)\$(ARCH_CC)_d.inc

# %jp{¹ԥեɹ}%en{definitions for exection file}
!include $(KERNEL_MAKINC_DIR)\makexe_d.inc


# %jp{ϥե̾}%en{output files}
TARGET_EXE = $(TARGET).$(EXT_EXE)




# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}


# %jp{Cեɲ}%en{C sources}
CSRCS = $(CSRCS) ..\kernel_cfg.c
CSRCS = $(CSRCS) ..\main.c
CSRCS = $(CSRCS) ..\sample.c
CSRCS = $(CSRCS) ..\ostimer.c
CSRCS = $(CSRCS) ..\wintimer.c


# %jp{֥ȥեɲ}%en{object files}
OBJS = $(OBJS) $(OBJS_DIR)\kernel_cfg.obj
OBJS = $(OBJS) $(OBJS_DIR)\main.obj
OBJS = $(OBJS) $(OBJS_DIR)\sample.obj
OBJS = $(OBJS) $(OBJS_DIR)\ostimer.obj
OBJS = $(OBJS) $(OBJS_DIR)\wintimer.obj


# %jp{饤֥ɲ}
LIBS = $(LIBS) user32.lib winmm.lib




# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
all: makeexe_all srcobjcp $(TARGET_EXE)

# %jp{꡼}%en{clean}
clean: makeexe_clean
	$(CMD_RM) $(TARGET_EXE) $(OBJS) ..\kernel_cfg.c ..\kernel_id.h

# %jp{ͥ뤴ȥ꡼}%en{mostlyclean}
mostlyclean: clean kernel_clean


# %jp{ե졼¹}%en{configurator}
..\kernel_cfg.c ..\kernel_id.h: ..\system.cfg
	cl /E ..\system.cfg > ..\system.i
	$(KERNEL_CFGRTR) ..\system.i -c ..\kernel_cfg.c -i ..\kernel_id.h
	$(CMD_CP) ..\kernel_cfg.c $(OBJS_DIR)\


# %jp{¹ԥեɹ}%en{rules for exection file}
!include $(KERNEL_MAKINC_DIR)\makexe_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
!include $(KERNEL_MAKINC_DIR)\$(ARCH_CC)_r.inc


# %jp{ԡ}%en{copy}
srcobjcp:
	$(CMD_CP) ..\*.c $(OBJS_DIR)



# --------------------------------------
#  %jp{¸ط}%en{dependency}
# --------------------------------------

$(OBJS_DIR)\kernel_cfg.obj	:	$(OBJS_DIR)\kernel_cfg.c ..\kernel_id.h
$(OBJS_DIR)\main.obj		:	$(OBJS_DIR)\main.c       ..\kernel_id.h
$(OBJS_DIR)\sample.obj		:	$(OBJS_DIR)\sample.c     ..\kernel_id.h
$(OBJS_DIR)\ostimer.obj		:	$(OBJS_DIR)\ostimer.c    ..\kernel_id.h
$(OBJS_DIR)\wintimer.obj	:	$(OBJS_DIR)\wintimer.c   ..\kernel_id.h



# end of file
