/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"
#include "wintimer.h"


#define OSTIMER_TIMER_INHNO		1			/**< %jp{ߥϥɥֹ} */


static void OsTimer_IrqHandler(void);		/**< %jp{޳ߥϥɥ} */


/** %jp{OSѥ޽롼} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_DINH dfinh;
	
	/* %jp{ߥϥɥ} */
	dfinh.inthdr = (FP)OsTimer_IrqHandler;
	def_inh(OSTIMER_TIMER_INHNO, &dfinh);
	
	/* %jp{ư} */
	WinTimer_Start(OSTIMER_TIMER_INHNO, 10);
}


/** %jp{޳ߥϥɥ} */
void OsTimer_IrqHandler(void)
{
	isig_tim();
}


/* end of file */
