/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  wintimer.c
 * @brief %jp{WindowsѤΥ}%en{Windows timer object}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


/** %jp{Windows إåեɤߤ} */
#define SIZE  WIN_SIZE
#include <windows.h>
#undef  SIZE

#include "kernel.h"
#include "wintimer.h"
#include "arch/proc/win/win32/proc.h"


static DWORD WINAPI WinTimer_Thread(LPVOID param);		/**< %jp{޳ѥåɴؿ} */
static HANDLE hEventTimer;								/**< %jp{ޥϥɥ} */


/** %jp{OSѥޤν} */
void WinTimer_Start(INHNO inhno, int iInterval)
{
	DWORD dwThreadId;
		
	/* %jp{ѥ٥Ȥκ} */
	hEventTimer = CreateEvent(NULL, FALSE, FALSE, NULL);
	
	/* %jp{ޥǥޤγ} */
	timeSetEvent(iInterval, 1, (LPTIMECALLBACK)hEventTimer, 0, TIME_PERIODIC | TIME_CALLBACK_EVENT_PULSE);
	
	/* %jp{å} */
	CreateThread(NULL, 0, WinTimer_Thread, (LPVOID)inhno, 0, &dwThreadId);
}


/** %jp{޳ѥåɴؿ} */
DWORD WINAPI WinTimer_Thread(LPVOID param)
{
	INHNO inhno;
	
	inhno = (INHNO)param;

	for ( ; ; )
	{
		/* %jp{ޥ٥ȤԤ} */
		WaitForSingleObject(hEventTimer, INFINITE);

		/* %jp{ߥʥ} */
		vsig_int(inhno);
	}
}


/* end of file */
