/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ITRON4.0 ɸإå                                                 */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#ifndef __HOS_V4T__itron_h__
#define __HOS_V4T__itron_h__



/* ------------------------------------ */
/*          ǡ                */
/* ------------------------------------ */

typedef signed char		B;			/* դ8ӥå */
typedef signed short	H;			/* դ16ӥå */
typedef signed long		W;			/* դ32ӥå */

typedef unsigned char	UB;			/* ̵8ӥå */
typedef unsigned short 	UH;			/* ̵16ӥå */
typedef unsigned long	UW;			/* ̵32ӥå */

typedef signed char		VB;			/* ǡפޤʤ8ӥåȤ */
typedef signed short	VH;			/* ǡפޤʤ16ӥåȤ */
typedef signed long		VW;			/* ǡפޤʤ32ӥåȤ */

typedef void			*VP;		/* ǡפޤʤΤؤΥݥ */
typedef void			(*FP)();	/* ץεưϡʥݥ󥿡 */

typedef signed   int	INT;		/* ץå˼ʥդ(16bitʾ) */
typedef unsigned int	UINT;		/* ץå˼ʥ̵(16bitʾ) */

typedef INT		BOOL;		/*  */

typedef INT		FN;			/* ǽ */
typedef INT		ER;			/* 顼 */
typedef UB		ID;			/* ֥ȤIDֹ */
typedef UB		ATR;		/* ֥Ȥ° */
typedef UB		STAT;		/* ֥Ȥξ */
typedef UB		MODE;		/* ӥư⡼ */
typedef UB		PRI;		/* ͥ */
typedef UW		SIZE;		/* ΰΥ */
typedef W		TMO;		/* ॢȻ */
typedef UW		RELTIM;		/* л */

typedef struct t_systim		/* ƥ */
{
	UW ltime;				/*  32bit */
	UH utime;				/*  16bit */
} SYSTIM;

typedef long	VP_INT;		/* VP ޤ INT */

typedef ER		ER_BOOL;	/* ER ޤ BOOL */

typedef W		ER_UINT;	/* ER ޤ UINT */

typedef INT		ER_ID;		/* ER ޤ ID */

typedef UH		TEXPTN;		/* 㳰װΥѥ */

typedef UH		FLGPTN;		/* ե饰ѥ */

typedef INT     EXCNO;		/* CPU㳰ϥɥֹ */

typedef INT		INHNO;		/* ߥϥɥֹ */
typedef INT		INTNO;		/* ֹ */



/* ------------------------------------ */
/*                              */
/* ------------------------------------ */

/*  */
#ifdef NULL		/* CɸإåȤζ */
#undef NULL
#endif

#ifdef __cplusplus
#define NULL		0			/* ̵ݥ */
#else
#define NULL		((void *)0)	/* ̵ݥ */
#endif

#define TRUE		1			/*  */
#define FALSE		0			/*  */
#define E_OK		0			/* ｪλ */


/* ֥° */
#define TA_NULL		0			/* ֥°ꤷʤ */
#define TA_HLNG		0x00		/* ѤΥ󥿡եǽñ̤ư */
#define TA_ASM		0x01		/* ֥ѤΥ󥿡եǽñ̤ư */

#define TA_TFIFO	0x00		/* ԤFIFO */
#define TA_TPRI		0x01		/* Ԥ򥿥ͥٽ */

#define TA_MFIFO	0x00		/* åԤFIFO */
#define TA_MPRI		0x02		/* åԤåͥٽ */

#define TA_ACT		0x02		/* ư줿֤ */
#define TA_RSTR		0x04		/* 󥿥 */

#define TA_WSGL		0x00		/* ٥ȥե饰ʣΥԤĤȤʤ */
#define TA_WMUL		0x02		/* ٥ȥե饰ʣΥԤĤȤ */
#define TA_CLR		0x04		/* Ԥ˥٥ȥե饰򥯥ꥢ */

#define TA_INHERIT	0x02		/* ߥ塼ƥåͥٷѾץȥ򥵥ݡ */
#define TA_CEILING	0x03		/* ߥ塼ƥåͥپ¥ץȥ򥵥ݡ */

#define TA_STA		0x02		/* ϥɥưƤ֤ */
#define TA_PHS		0x04		/* ϥɥΰ¸ */


/* ॢȻ */
#define TMO_POL		0			/* ݡ */
#define TMO_FEVR	(-1)		/* ʵԤ */
#define TMO_NBLK	(-2)		/* Υ֥å */


/* ӥư⡼ */
#define TWF_ANDW	0x00		/* ٥ȥե饰ANDԤ */
#define TWF_ORW		0x01		/* ٥ȥե饰ORԤ */


/* ֥Ȥξ */
#define TTS_RUN		0x01		/* ¹Ծ */
#define TTS_RDY		0x02		/* ¹Բǽ */
#define TTS_WAI		0x04		/* Ԥ */
#define TTS_SUS		0x08		/* Ԥ */
#define TTS_WAS		0x0c		/* Ԥ */
#define TTS_DMT		0x10		/* ٻ߾ */

#define TTW_SLP		0x0001		/* Ԥ */
#define TTW_DLY		0x0002		/* ַвԤ */
#define TTW_SEM		0x0004		/* ޥե񸻤γԤ */
#define TTW_FLG		0x0008		/* ٥ȥե饰Ԥ */
#define TTW_SDTQ	0x0010		/* ǡ塼ؤԤ */
#define TTW_RDTQ	0x0020		/* ǡ塼μԤ */
#define TTW_MBX		0x0040		/* ᡼ܥåμԤ */
#define TTW_MTX		0x0080		/* ߥ塼ƥåΥåԤ */
#define TTW_SMBF	0x0100		/* åХåեؤԤ */
#define TTW_RMBF	0x0200		/* åХåեμԤ */
#define TTW_CAL		0x0400		/* ǥ֤θƤӽФԤ */
#define TTW_ACP		0x0800		/* ǥ֤μԤ */
#define TTW_RDV		0x1000		/* ǥ֤νλԤ */
#define TTW_MPF		0x2000		/* Ĺ֥åγԤ */
#define TTW_MPL		0x4000		/* Ĺ֥åγԤ */

#define TTEX_ENA	0x00		/* 㳰ľ */
#define TTEX_DIS	0x01		/* 㳰ػ߾ */

#define TCYC_STP	0x00		/* ϥɥ餬ưƤʤ */
#define TCYC_STA	0x01		/* ϥɥ餬ưƤ */

#define TALM_STP	0x00		/* 顼ϥɥ餬ưƤʤ */
#define TALM_STA	0x00		/* 顼ϥɥ餬ưƤ */

#define TOVR_STP	0x00		/* ¥ץå֤ꤵƤʤ */
#define TOVR_STA	0x01		/* ¥ץå֤ꤵƤ */

/* ¾ */
#define TSK_SELF	0			/*  */
#define TSK_NONE	0			/* 륿̵ */

#define TPRI_SELF	0			/* Υ١ͥ٤λ */
#define TPRI_INI	0			/* εưͥ٤λ */


/* 顼 */
#define E_SYS		(-5)		/* ƥ२顼 */
#define E_NOSPT		(-9)		/* ̤ݡȵǽ */
#define E_RSFN		(-10)		/* ͽǽ */
#define E_RSATR		(-11)		/* ͽ° */
#define E_PAR		(-17)		/* ѥ᡼顼 */
#define E_ID		(-18)		/* IDֹ */
#define E_CTX		(-25)		/* ƥȥ顼 */
#define E_MACV		(-26)		/* ꥢȿ */
#define E_OACV		(-27)		/* ֥ȥȿ */
#define E_ILUSE		(-28)		/* ӥ */
#define E_NOMEM		(-33)		/* ­ */
#define E_NOID		(-34)		/* IDֹ­ */
#define E_OBJ		(-41)		/* ֥Ⱦ֥顼 */
#define E_NOEXS		(-42)		/* ֥̤ */
#define E_QOVR		(-43)		/* 塼󥰥Сե */
#define E_RLWAI		(-49)		/* Ԥ֤ζ */
#define E_TMOUT		(-50)		/* ݡ󥰼Ԥޤϥॢ */
#define E_DLT		(-51)		/* Ԥ֥Ȥκ */
#define E_CLS		(-52)		/* Ԥ֥ȤξѲ */
#define E_WBLK		(-57)		/* Υ֥å󥰼դ */
#define E_BOVR		(-58)		/* ХåեСե */


/* IDϰ(HOSȼ) */
#define TMIN_TSKID	1			/* IDֹκǾ */
#define TMIN_SEMID	1			/* ޥեIDֹκǾ */
#define TMIN_FLGID	1			/* ٥ȥե饰IDֹκǾ */
#define TMIN_DTQID	1			/* ǡ塼IDֹκǾ */
#define TMIN_MBXID	1			/* ᡼ܥåIDֹκǾ */
#define TMIN_MBFID	1			/* åХåեIDֹκǾ */
#define TMIN_MPFID	1			/* ĹסIDֹκǾ */
#define TMIN_CYCID	1			/* ϥɥIDֹκǾ */
#define TMIN_ALMID	1			/* 顼ϥɥIDֹκǾ */
#define TMIN_ISRID	1			/* ߥӥ롼IDֹκǾ */



/* ------------------------------------ */
/*           ޥ                 */
/* ------------------------------------ */


/* 顼ɼФ */
#define	MERCD(ercd)		((ER)((B)(ercd)))		/* 顼ɤᥤ󥨥顼ɤФ */
#define	SERCD(ercd)		((ercd) >> 8)			/* 顼ɤ饵֥顼ɤФ */



#endif /* __HOS_V4T__itron_h__ */



/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
