/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny ץץ                       */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"
#include "kernel_id.h"
#include "h83664f.h"
#include "h8t_sci.h"


/* ᥤؿ */
int main()
{
	char *p;

	/* SCIν */
	Sci_Initialize(SCI_19200);

	/* ϥå */
	for ( p="HOS V4 Tiny\r\ntest program start!\r\n"; *p!='\0'; p++)
		Sci_PutChar( *p);

	sta_hos();
	
	return 0;
}

/* ϥɥ */
void Initialize(VP_INT exinf)
{
	IO.PMR1.BYTE = 0x02; /* port1TXD bitʳϥݡȤ */
	IO.PCR1      = 0xff; /* port1ϥݡȤ */
}

const char mes1[] = "Task: ID -> ";
const char mes2[] = " :EXINF -> ";

/* ץ륿
   ֵưɤͿ줿򵯤,ʬ̲פ򷫤֤ */
void Task(VP_INT exinf)
{
	char	*p;
	int	tid = KERNEL_GET_RUN_TSKID();

	/* TASK: ID -> tid : EXINF -> exinf ; ưɤγǧ */
	wai_sem(SID_SCI);
	for ( p=mes1; *p!='\0'; p++)
			Sci_PutChar( *p);
	Sci_PutChar( '0'+tid);
	for ( p=mes2; *p!='\0'; p++)
			Sci_PutChar( *p);
	Sci_PutChar( '0'+exinf);
	Sci_PutChar( '\r');
	Sci_PutChar( '\n');
	sig_sem(SID_SCI);

	for ( ; ; )
	{
		wai_sem(SID_SCI);
		/* TASK: ID -> X  ; ¹ԥIDǧ */
		for ( p=mes1; *p!='\0'; p++)
			Sci_PutChar( *p);
		Sci_PutChar( '0'+tid);
		Sci_PutChar( '\r');
		Sci_PutChar( '\n');
		sig_sem(SID_SCI);
		wup_tsk((ID)exinf);	/* ŪΥ򵯤 */
		slp_tsk();		/* ʬϿ */
	}
}

const char chop[] = "*****\r\n";
/* SCIΥޥե䤢м*****Ϥ륿 */
void Chop(VP_INT exinf)
{
	char *p;

	for (;;)
	{
		wai_sem(SID_SCI);
		for ( p=chop; *p!='\0'; p++)
			Sci_PutChar( *p);
		sig_sem(SID_SCI);
		/* Ūư˵ޤǿ */
		slp_tsk();
	}
}

/* ޳ߤǤȥե饰ϢưƼŪư򤹤륿 */
void Cycl(VP_INT exinf)
{
	int i;

	for (i=1;;i++)
	{
		wai_flg( FID_CYC, 1, TWF_ANDW, NULL);
		clr_flg( FID_CYC, 0);
		IO.PDR1.BYTE = ~(IO.PDR1.BYTE);
		/* ʬƿƤChop򵯤 */
		if ((i&0x1) == 0) wup_tsk( exinf);
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
