/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ̥ͥ                                                  */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* ǥѥåμ¹ */
void kernel_exe_dsp(void)
{
	T_HOSPAC_CTXINF *ctxinf_top;
	T_HOSPAC_CTXINF *ctxinf_run;
	ID              tskid_top;
	ID              tskid_run;

	/* ڤؤɬפɤå */
	if ( KERNEL_GET_RUN_TSKID() == kernel_ref_qhd(KERNEL_GET_RDYQUE()) )
	{
		return;
	}

	/* ƥȥå */
	if ( kernel_sys.stat != KERNEL_TSS_TSK )
	{
		kernel_sys.dly_dsp = TRUE;	/* ǥѥåǽǤʤͽ󤷤ƽλ */
		return;
	}

	/* ǹͥ٤μ¹Բǽ */
	tskid_top  = kernel_ref_qhd(KERNEL_GET_RDYQUE());
	ctxinf_top = &KERNEL_GET_TCB(tskid_top)->ctxinf;
	
	/* ¹楿IDμ */
	tskid_run  = KERNEL_GET_RUN_TSKID();
	ctxinf_run = &KERNEL_GET_TCB(tskid_run)->ctxinf;
	
	/* ¹ԥϿ */
	KERNEL_SET_RUN_TSKID(tskid_top);
	
	/* ƥȥå¹ */
	hospac_swi_ctx(ctxinf_run, ctxinf_top);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
