package coboled.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CobolEditor extends TextEditor {
	
	private CobolOutlinePage outlinePage;
	
	private EditorSelectionChangedListener selectionChangeListener; 
	
	private ColorManager colorManager;

	public CobolEditor() {
		super();
		colorManager = new ColorManager();
		setSourceViewerConfiguration(new CobolConfiguration(colorManager));
		setDocumentProvider(new CobolDocumentProvider());
	}
	
	public void dispose() {
		if (selectionChangeListener != null) {
			selectionChangeListener.uninstall(getSelectionProvider());
			selectionChangeListener = null;
		} 
		if(colorManager != null) colorManager.dispose();
		if(outlinePage != null)  outlinePage.dispose();
		super.dispose();
	}
	
	@Override
	public Object getAdapter(Class adapter) {
		if (IContentOutlinePage.class.equals(adapter)) {
			if (outlinePage == null) {
				outlinePage = new CobolOutlinePage(this);
			}
			return outlinePage;
		}
		return super.getAdapter(adapter);
	}

	@Override
	public void doSave(IProgressMonitor progressMonitor) {
		super.doSave(progressMonitor);
		outlinePage.refresh();
		outlinePage.setSelection(getSourceViewer().getTextWidget().getCaretOffset()); 
	}

	@Override
	public void doSaveAs() {
		super.doSaveAs();
		outlinePage.refresh();
		outlinePage.setSelection(getSourceViewer().getTextWidget().getCaretOffset());
	}
	
	@Override
	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		selectionChangeListener = new EditorSelectionChangedListener();
		selectionChangeListener.install(getSelectionProvider());
	}

	@Override
	protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(
			ISourceViewer viewer) {
		if (fSourceViewerDecorationSupport == null) {
			fSourceViewerDecorationSupport =
				new CobolViewerDecorationSupport(viewer, getOverviewRuler(),
						getAnnotationAccess(), getSharedColors());
			configureSourceViewerDecorationSupport(fSourceViewerDecorationSupport);
		}
		return fSourceViewerDecorationSupport;
	}

	@Override
	protected void initializeKeyBindingScopes() {
		super.initializeKeyBindingScopes();
		setKeyBindingScopes(new String[]{"coboled.editors.cobolEditorScope"});
	}
	
	private class EditorSelectionChangedListener extends AbstractSelectionChangedListener {

		public void selectionChanged(SelectionChangedEvent event) {
			if(outlinePage != null) {
				ISelection selection = event.getSelection();
				ITextSelection textSelection = (ITextSelection) selection;
				outlinePage.setSelection(textSelection.getOffset());
			}
		} 
		
	}
}
