package coboled.editors;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import coboled.Activator;

public class CobolLabelProvider extends LabelProvider {

	private Image divisionImage = Activator.getImageDescriptor(
			"icons/public_co.gif").createImage();

	private Image sectionImage = Activator.getImageDescriptor(
			"icons/protected_co.gif").createImage();

	private Image paragraphImage = Activator.getImageDescriptor(
			"icons/private_co.gif").createImage();
	
	private Image dataImage = Activator.getImageDescriptor(
			"icons/field_private_obj.gif").createImage();

	@Override
	public Image getImage(Object element) {
		if (element instanceof CobolElement) {
			switch (((CobolElement)element).getType().getLebel()) {
			case 1:
				return divisionImage;
			case 2:
				return sectionImage;
			case 3:
				return paragraphImage;
			case 4:
				return dataImage;
			default:
				return null;
			}
		}
		return null;
	}

	@Override
	public String getText(Object element) {
		if (element instanceof CobolElement) {
			return ((CobolElement) element).getName();
		}
		return super.getText(element);
	}

	@Override
	public void dispose() {
		divisionImage.dispose();
		sectionImage.dispose();
		paragraphImage.dispose();
		super.dispose();
	}
}
