#ifndef TURING_H
#define TURING_H
#include <stdio.h>
#include <stdlib.h>

#define MAXSTATUS (10)
#define MAXTAPE   (1024)
#define MAXRULE   (128)


typedef struct turingRule {
	/* input */
	char currentStatus[MAXSTATUS];
	char inputData;	 
	/* output */	
	char outputData;
	char movement; 
	char nextStatus[MAXSTATUS];
} turingRule;

typedef struct turingMachine {
	char data;

	char status[MAXSTATUS];
	int  currentPosition;

	int        currentRule;
	int        maxRule;
	turingRule rule[MAXRULE];
} turingMachine;

typedef struct turingTape {
	int 	lastPosition;
	char 	tape[MAXTAPE];
}turingTape;


/* turingTape.c */
int turingTapeRead(FILE* fpt, turingTape* tape);
int turingTapePrint(FILE* fpt, turingTape tape);

/* turingRule.c */
int turingRuleRead(FILE* fpt, turingRule rule[]); 
int turingRulePrint(FILE* fpt, turingRule rule[], int max); 
int turingRulePrint0(FILE* fpt, turingRule rule);
/* turingMachine.c */
int turingMachineRun(turingMachine* TM, turingTape* tape, FILE* fpt, int mode);

int turingMachinePrint(turingMachine* TM, turingTape* tape, FILE* fpt, int count, int mode);

int turingMachineOneStep(turingMachine* TM, turingTape* tape);
int turingMachineInput(turingMachine* TM, turingTape tape);
int turingMachineRuleSelect(turingMachine* TMP, turingTape* tape);
int turingMachineOutput(turingMachine TM, turingTape* tape);
int turingMachineMove(turingMachine* m);
int turingMachineStatusChange(turingMachine* m);
int turingMachineHalt(turingMachine* m);
#endif

