#include "DllMain.h"
#include "ClassFactory.h"
#include "ContextMenu.h"

const CLSID CLSID_ContextMenuSample = {0x112143a6, 0x62c1, 0x4478, {0x9e, 0x8f, 0x87, 0x26, 0x99, 0x25, 0x5e, 0x2e}};
LONG      g_lLocks = 0;
HINSTANCE g_hinstDll = NULL;

void MyLoadString(std::wstring& str,UINT id)
{
	const int incriment = 256;
	int length = incriment;
	LPWSTR text;
	for(;;)
	{
		text = (LPWSTR)_malloca(length * 2);
		int result = ::LoadString(g_hinstDll,id,text,length);
		if(result == 0)
			throw "Not Found Resource";
		else if(result < length)
		{
			str = text;
			_freea(text);
			break;
		}
		_freea(text);
		length += incriment;
	}
}

void GetModulePath(WCHAR szOutput[],int length)
{
	WCHAR szPath[_MAX_PATH];
	WCHAR szDrive[_MAX_DRIVE];
	WCHAR szDir[_MAX_DIR];
	WCHAR szFileName[_MAX_FNAME];
	WCHAR szExt[_MAX_EXT];

	//
	memset(szPath, 0x00, sizeof(szPath));
	memset(szDrive, 0x00, sizeof(szDrive));
	memset(szDir, 0x00, sizeof(szDir));
	memset(szExt, 0x00, sizeof(szExt));
	memset(szOutput, 0x00, sizeof(szOutput));
	
	//s̃vZX̃tpX擾
	DWORD dwRet = GetModuleFileName(g_hinstDll, szPath, sizeof(szPath));
	if(dwRet == 0) {
	//G[Ȃ(ȗ)
	}
	
	//tpX𕪊
	_wsplitpath_s(szPath, szDrive,sizeof(szDrive), szDir,sizeof(szDir), szFileName,sizeof(szFileName), szExt,sizeof(szExt)); 

	StringCbPrintf(szOutput,length,L"%s%s",szDrive,szDir);
}

void LockModule(BOOL bLock)
{
	if (bLock)
		InterlockedIncrement(&g_lLocks);
	else
		InterlockedDecrement(&g_lLocks);
}

STDAPI DllCanUnloadNow()
{
	return g_lLocks == 0 ? S_OK : S_FALSE;
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID *ppv)
{
	static CClassFactory serverFactory;
	HRESULT hr;

	*ppv  = NULL;
	
	if (IsEqualCLSID(rclsid, CLSID_ContextMenuSample))
		hr = serverFactory.QueryInterface(riid, ppv);
	else
		hr = CLASS_E_CLASSNOTAVAILABLE;

	return hr;
}

STDAPI DllRegisterServer(void)
{
	return S_OK;
}

STDAPI DllUnregisterServer(void)
{
	return S_OK;
}

BOOL WINAPI DllMain(HINSTANCE hinstDll, DWORD dwReason, LPVOID lpReserved)
{
	switch (dwReason) {

	case DLL_PROCESS_ATTACH:
		g_hinstDll = hinstDll;
		DisableThreadLibraryCalls(hinstDll);
		return TRUE;

	}

	return TRUE;
}
