﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.IO;

namespace CompleteEraser
{
    class BreakRecyleBin : IOperation
    {
        [DllImport("shell32.dll")]
        static extern int SHEmptyRecycleBin(IntPtr hWnd, string pszRootPath,uint dwFlags);
        //     No dialog box confirming the deletion of the objects will be displayed.
        const uint SHERB_NOCONFIRMATION = 0x00000001;
        //     No dialog box indicating the progress will be displayed.
        const uint SHERB_NOPROGRESSUI = 0x00000002;
        //     No sound will be played when the operation is complete.
        const uint SHERB_NOSOUND = 0x00000004;        

        public event ProgressingEventHandler Progressing;
        public event ProgressedEventHandler Progressed;

        public void Execute(IEnumerable<string> files)
        {
            foreach (string file in files)
            {
                Progressing(this, new ProgressingEventArgs(file));

                try
                {
                    FileBreaker.BreakFileOrFolder(file);
                }
                catch(IOException){
                    //ゴミ箱の中にフォルダーがあるとIOErrorがでるので握りつぶす
                }

                Progressed(this, new ProgressedEventArgs(file,null));
            }

            Progressing(this, new ProgressingEventArgs(null));
            SHEmptyRecycleBin(IntPtr.Zero, "", SHERB_NOCONFIRMATION | SHERB_NOPROGRESSUI);
        }
    }
}
