﻿using System;
using System.Collections.Generic;
using System.IO;

namespace CompleteEraser
{
    class ShrredFiles : IOperation
    {
        public event ProgressingEventHandler Progressing;
        public event ProgressedEventHandler Progressed;

        public void Execute(IEnumerable<string> files)
        {
            foreach (string file in files)
            {
                Progressing(this,new ProgressingEventArgs(file));

            RETRY:
                ProgressedEventArgs e = new ProgressedEventArgs(file,null);

                try
                {
                    FileBreaker.BreakFileOrFolder(file);
                }
                catch (UnauthorizedAccessException uae)
                {
                    e.ex = uae;
                }
                catch (IOException ie)
                {
                    e.ex = ie;
                }
                Progressed(this, e);
                if (e.retry)
                    goto RETRY;
                if (e.breaked)
                    break;
            }
        }
    }
}
