/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.dbInfo;

import jp.co.connectone.dbInfo.DbType;
import jp.co.connectone.dbInfo.HsqldbDbInfo;
import jp.co.connectone.dbInfo.MSSqlDbInfo;
import jp.co.connectone.dbInfo.MYSqlDbInfo;

public abstract class DbInfo {
    protected String DB_URL;
    protected String DATA_PATH;
    protected String DATA_DIR;
    protected String DB_NAME;
    protected String DB_DRIVER;
    protected String DB_USER;
    protected String DB_PASS;
    protected String DB_GETUSER_SQL_V3;
    protected String DB_GETDEACTIVATE_USER_SQL_V3;
    protected String DB_SERVICE_UPDATE_SQL_V3;
    protected String DB_SERVICE_INSERT_SQL_V3;
    protected String DB_GETOID_SQL;
    protected String DB_GETTERMID_SQL;
    protected String DB_USER_INSERT_SQL;
    protected String DB_USER_UPDATE_SQL;
    protected String DB_USER_SETFLAG_SQL;
    protected String DB_EXCH_INSERT_SQL;
    protected String DB_TERM_INSERT_SQL;
    protected String DB_EXCH_UPDATE_SQL;
    protected String DB_TERM_UPDATE_SQL;

    public static DbInfo getInstance(DbType type) {
        DbInfo info = null;
        if (type == DbType.HSQLDB) {
            info = new HsqldbDbInfo();
        } else if (type == DbType.MSSQL) {
            info = new MSSqlDbInfo();
        } else if (type == DbType.MYSQL) {
            info = new MYSqlDbInfo();
        }
        return info;
    }

    public String getDbUrl() {
        return String.valueOf(this.DB_URL) + this.DATA_PATH + this.DATA_DIR + this.DB_NAME;
    }

    public String getDbUrl(String serverName) {
        return String.valueOf(this.DB_URL) + serverName + this.DATA_DIR + this.DB_NAME;
    }

    public String getDB_DRIVER() {
        return this.DB_DRIVER;
    }

    public String getDB_GETDEACTIVATE_USER_SQL_V3() {
        return this.DB_GETDEACTIVATE_USER_SQL_V3;
    }

    public String getDB_EXCH_INSERT_SQL() {
        return this.DB_EXCH_INSERT_SQL;
    }

    public String getDB_EXCH_UPDATE_SQL() {
        return this.DB_EXCH_UPDATE_SQL;
    }

    public String getDB_GETOID_SQL() {
        return this.DB_GETOID_SQL;
    }

    public String getDB_GETTERMID_SQL() {
        return this.DB_GETTERMID_SQL;
    }

    public String getDB_GETUSER_SQL_V3() {
        return this.DB_GETUSER_SQL_V3;
    }

    public String getDB_SERVICE_UPDATE_SQL_V3() {
        return this.DB_SERVICE_UPDATE_SQL_V3;
    }

    public String getDB_SERVICE_INSERT_SQL_V3() {
        return this.DB_SERVICE_INSERT_SQL_V3;
    }

    public String getDB_USER() {
        return this.DB_USER;
    }

    public String getDB_PASS() {
        return this.DB_PASS;
    }

    public String getDB_URL() {
        return this.DB_URL;
    }

    public String getDATA_PATH() {
        return this.DATA_PATH;
    }

    public String getDATA_DIR() {
        return this.DATA_DIR;
    }

    public String getDB_NAME() {
        return this.DB_NAME;
    }

    public String getDB_USER_INSERT_SQL() {
        return this.DB_USER_INSERT_SQL;
    }

    public String getDB_USER_UPDATE_SQL() {
        return this.DB_USER_UPDATE_SQL;
    }

    public String getDB_USER_SETFLAG_SQL() {
        return this.DB_USER_SETFLAG_SQL;
    }

    public String getDB_TERM_INSERT_SQL() {
        return this.DB_TERM_INSERT_SQL;
    }

    public String getDB_TERM_UPDATE_SQL() {
        return this.DB_TERM_UPDATE_SQL;
    }
}

