/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store.pim;

import java.util.Date;
import jp.co.connectone.store.pim.IMailParseHelperComparator;
import jp.co.connectone.store.pim.MailParseHelper;

public class NotesMailParseHelperComparator
extends IMailParseHelperComparator {
    public static final int SUBJECT = 0;
    public static final int SENTDATE = 1;
    public static final int RECEIVEDDATE = 2;
    private int sortKey = 0;
    private boolean reverce = false;

    public NotesMailParseHelperComparator(int sortKey, boolean isReverce) {
        super(sortKey, isReverce);
        this.sortKey = sortKey;
        this.reverce = isReverce;
    }

    public int compare(MailParseHelper o1, MailParseHelper o2) {
        if (o1 == null) {
            return 0;
        }
        if (o2 == null) {
            return 0;
        }
        MailParseHelper src = o1;
        MailParseHelper dst = o2;
        switch (this.sortKey) {
            case 0: {
                String s1 = src.getSubject();
                String s2 = dst.getSubject();
                if (s1 == null || s2 == null) {
                    return 0;
                }
                if (this.reverce) {
                    return s2.compareTo(s1);
                }
                return s1.compareTo(s2);
            }
            case 1: {
                Date d1 = src.getSentDate();
                Date d2 = dst.getSentDate();
                if (d1 == null || d2 == null) {
                    return 0;
                }
                if (this.reverce) {
                    return d2.compareTo(d1);
                }
                return d1.compareTo(d2);
            }
            case 2: {
                Date d1 = src.getReceivedDate();
                Date d2 = dst.getReceivedDate();
                if (d1 == null || d2 == null) {
                    return 0;
                }
                if (this.reverce) {
                    return d2.compareTo(d1);
                }
                return d1.compareTo(d2);
            }
        }
        return 0;
    }
}

