/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.pop3.store.EAIPop3Base;
import jp.co.connectone.eai.pop3.store.Pop3FolderIndex;
import jp.co.connectone.eai.pop3.store.Pop3ObjectIndex;
import jp.co.connectone.eai.pop3.store.Pop3ObjectIndexRawDataDateAndSubject;
import jp.co.connectone.eai.pop3.store.Pop3ServiceInfo;
import jp.co.connectone.eai.pop3.user.Pop3AccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.BasicMailDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.IMailStore;
import jp.co.connectone.store.pim.MailAddress;
import jp.co.connectone.user.IAccountData;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Pop3MailStoreImpl
extends EAIPop3Base
implements IMailStore {
    public static final IStoreID storeID;
    public static final String storeName = "Pop3 Mail Store";
    private String bodyText = null;
    private ArrayList<AttachmentDTO> attach = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        Pop3MailStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Pop3MailStoreImpl.class.getName());
    }

    public static Pop3MailStoreImpl getInstance() {
        return new Pop3MailStoreImpl();
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Pop3ServiceInfo(storeID, storeName);
    }

    public void deleteMail(IAccountData acc, IObjectIndex oidx) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Object oid = oidx.getIndex();
        String string = "deleteMail::oid=" + oid;
        Pop3MailStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        if (oid instanceof String) {
            super.delete(oid.toString());
        } else {
            super.delete((Pop3ObjectIndexRawDataDateAndSubject)oid);
        }
    }

    public IMailDTO[] getHeaders(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO[] headers = null;
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        Vector<String> v = new Vector<String>();
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Message[] col = super.getList(dest.getFolder().getIndex().toString(), v);
        int len = col.length;
        if (len == 0) {
            return new IMailDTO[0];
        }
        headers = new IMailDTO[1];
        ArrayList<IMailDTO> ar = new ArrayList<IMailDTO>();
        int i = len - 1;
        while (i >= 0) {
            ar.add(this.populateIMailDTO((MimeMessage)col[i]));
            --i;
        }
        headers = ar.toArray(headers);
        return headers;
    }

    public IMailDTO[] getHeadersByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO[] headers = null;
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        Vector<String> v = new Vector<String>();
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Message[] col = super.getListByDate(dest.getFolder().getIndex().toString(), v, date);
        int len = col.length;
        if (len == 0) {
            return new IMailDTO[0];
        }
        headers = new IMailDTO[1];
        ArrayList<IMailDTO> ar = new ArrayList<IMailDTO>();
        int i = len - 1;
        while (i >= 0) {
            ar.add(this.populateIMailDTO((MimeMessage)col[i]));
            --i;
        }
        headers = ar.toArray(headers);
        return headers;
    }

    public IMailDTO getMail(IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO l_IMailDTOObj = null;
        if (oidx == null) {
            throw new IncorrectData("message-id is null. cannot retrieve data.");
        }
        if (!(acc instanceof Pop3AccountData)) {
            throw new IncorrectData("account data type must be Pop3AccountData");
        }
        Pop3AccountData pacc = (Pop3AccountData)acc;
        this.setUserID(pacc.getUserID());
        this.setPassword(pacc.getPassword());
        this.setServerAddress(acc.getServiceInfo().getServerAddress());
        Object oid = oidx.getIndex();
        String string = "getMail::oid=" + oid;
        Pop3MailStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        MimeMessage mail = null;
        mail = oid instanceof String ? super.getMail(oid.toString()) : super.getMail((Pop3ObjectIndexRawDataDateAndSubject)oid);
        l_IMailDTOObj = this.populateIMailDTO(mail);
        return l_IMailDTOObj;
    }

    public FolderMetadata[] getMailFolders(IAccountData arg0, ISearchDestination arg1) throws StoreNotFound, NoSuchRights, ServerDown, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        FolderMetadata[] folders = new FolderMetadata[]{this.populateFolder(new Pop3FolderIndex())};
        return folders;
    }

    public IMailDTO[] getMailsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        return this.getHeadersByDate(acc, dest, date);
    }

    public IMailDTO[] getSentMails(IAccountData arg0) throws ServerDown, HandleException {
        throw new HandleException("Pop3 Mail Store does not support getSentMails.");
    }

    public IMailDTO[] getSentMailsByDate(IAccountData arg0, Date arg1) throws ServerDown, HandleException {
        throw new HandleException("Pop3 Mail Store does not support getSentMailsByDate.");
    }

    public IObjectIndex[] getUIDLs(IAccountData acc, ISearchDestination dest) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO[] headers = this.getHeaders(acc, dest);
        if (headers == null) {
            return new Pop3ObjectIndex[0];
        }
        ArrayList<Pop3ObjectIndex> uidlarray = new ArrayList<Pop3ObjectIndex>();
        int i = 0;
        while (i < headers.length) {
            try {
                String uidl = headers[i].getHeader().getHeaderUIDL();
                if (uidl == null) {
                    String string = "skip message " + headers[i].getHeader().getHeaderSubject() + " because of no Message-ID.";
                    Pop3MailStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
                } else {
                    uidlarray.add(new Pop3ObjectIndex(uidl));
                }
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
            ++i;
        }
        Pop3ObjectIndex[] uidls = new Pop3ObjectIndex[1];
        uidls = uidlarray.toArray(uidls);
        return uidls;
    }

    public IObjectIndex[] getUIDLsByDate(IAccountData acc, ISearchDestination dest, Date date) throws StoreNotFound, ServerDown, NoSuchRights, IncorrectStore, DataNotFound, IncorrectData, HandleException {
        IMailDTO[] headers = this.getHeadersByDate(acc, dest, date);
        if (headers == null) {
            return new Pop3ObjectIndex[0];
        }
        ArrayList<Pop3ObjectIndex> uidlarray = new ArrayList<Pop3ObjectIndex>();
        int i = 0;
        while (i < headers.length) {
            try {
                String uidl = headers[i].getHeader().getHeaderUIDL();
                if (uidl == null) {
                    String string = "skip message " + headers[i].getHeader().getHeaderSubject() + " because of no Message-ID.";
                    Pop3MailStoreImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
                } else {
                    uidlarray.add(new Pop3ObjectIndex(uidl));
                }
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
            ++i;
        }
        Pop3ObjectIndex[] uidls = new Pop3ObjectIndex[1];
        uidls = uidlarray.toArray(uidls);
        return uidls;
    }

    public IObjectIndex sendMail(IAccountData arg0, IMailDTO arg1) throws NoSuchRights, ServerDown, IncorrectData, HandleException {
        throw new HandleException("Pop3 Mail Store does not support sendMail.");
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws Exception {
        this.deleteMail(acc, oidx);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getHeaders(acc, dest);
    }

    public IRecordObject getFolderIndexFromString(String arg0) throws IncorrectData {
        return new Pop3FolderIndex();
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getMailFolders(acc, dest);
    }

    public String getName() throws Exception {
        return storeName;
    }

    public ISearchDestination getPresetDestination(IAccountData arg0, int arg2) throws IncorrectData, HandleException {
        BasicSearchDestination dst = new BasicSearchDestination(null, (IFolderIndex)new Pop3FolderIndex());
        return dst;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        Pop3ServiceInfo info = new Pop3ServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        return info;
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oidx) throws Exception {
        return this.getMail(acc, dest, oidx);
    }

    public IRecordObject[] search(IAccountData arg0, ISearchFormula arg1) throws Exception {
        throw new HandleException("Pop3 Mail Store does not support search.");
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return this.getHeadersByDate(acc, dest, date);
    }

    public IObjectIndex write(IAccountData arg0, ISearchDestination arg1, IRecordObject arg2) throws Exception {
        throw new HandleException("Pop3 Mail Store does not support write.");
    }

    private IMailDTO populateIMailDTO(MimeMessage src) throws HandleException {
        HeaderDTO l_headerDTOObj;
        BasicMailDTO l_IMailDTOObj;
        block33: {
            l_IMailDTOObj = new BasicMailDTO();
            l_headerDTOObj = new HeaderDTO();
            String tmp = null;
            try {
                int i;
                l_headerDTOObj.setHeaderUIDL(src.getMessageID());
                String messageId = src.getMessageID();
                if (messageId == null) {
                    String subject = src.getSubject();
                    Date date = src.getReceivedDate();
                    l_headerDTOObj.setOid((IObjectIndex)new Pop3ObjectIndex(Pop3ObjectIndex.makeIndexByDateAndSubject(date, subject)));
                } else {
                    l_headerDTOObj.setOid((IObjectIndex)new BasicObjectIndex((Object)messageId));
                }
                Address[] add = null;
                try {
                    add = src.getFrom();
                }
                catch (AddressException date) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException date) {
                        // empty catch block
                    }
                    l_headerDTOObj.setHeaderFrom(tmp);
                }
                l_headerDTOObj.setHeaderSubject(src.getSubject());
                int pri = 0;
                String[] priStr = src.getHeader("importance");
                if (priStr == null) {
                    priStr = src.getHeader("priority");
                }
                try {
                    if (priStr != null) {
                        pri = Integer.parseInt(priStr[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l_headerDTOObj.setHeaderPriority(pri);
                try {
                    add = src.getReplyTo();
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    tmp = add[0].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[0].toString());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    l_headerDTOObj.setHeaderReplyTo(tmp);
                }
                l_headerDTOObj.setHeaderSize(src.getSize());
                l_headerDTOObj.setHeaderSendDate(src.getSentDate());
                try {
                    add = src.getRecipients(Message.RecipientType.CC);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
                if (add != null) {
                    MailAddress[] cc = new MailAddress[add.length];
                    i = 0;
                    while (i < add.length) {
                        MailAddress address;
                        tmp = add[i].toString();
                        try {
                            tmp = MimeUtility.decodeText((String)add[i].toString());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        cc[i] = address = new MailAddress(tmp);
                        ++i;
                    }
                    l_headerDTOObj.setHeaderCC(cc);
                }
                try {
                    add = src.getRecipients(Message.RecipientType.TO);
                }
                catch (AddressException cc) {
                    // empty catch block
                }
                if (add == null) break block33;
                MailAddress[] to = new MailAddress[add.length];
                i = 0;
                while (i < add.length) {
                    tmp = add[i].toString();
                    try {
                        tmp = MimeUtility.decodeText((String)add[i].toString());
                    }
                    catch (UnsupportedEncodingException address) {
                        // empty catch block
                    }
                    to[i] = address = new MailAddress(tmp);
                    ++i;
                }
                l_headerDTOObj.setHeaderTo(to);
            }
            catch (MessagingException e) {
                e.printStackTrace();
                if (!(e instanceof MessageRemovedException)) {
                    throw new HandleException(e.getMessage());
                }
                String string = "skip this message...";
                Pop3MailStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
            }
        }
        l_IMailDTOObj.setHeaderDTO(l_headerDTOObj);
        this.retrieveAllParts((Part)src);
        try {
            this.bodyText = new String(this.bodyText.getBytes("Shift-JIS"), "MS932");
        }
        catch (Exception e) {
            // empty catch block
        }
        l_IMailDTOObj.setBody(this.bodyText);
        if (this.attach != null) {
            AttachmentDTO[] list = this.attach.toArray(new AttachmentDTO[1]);
            l_IMailDTOObj.setAttachments(list);
            String string = list.toString();
            Pop3MailStoreImpl.debug_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
        }
        this.attach = null;
        return l_IMailDTOObj;
    }

    private void retrieveAllParts(Part part) throws IncorrectData, HandleException {
        try {
            if (part.isMimeType("multipart/*")) {
                Multipart subPart = (Multipart)part.getContent();
                int i = 0;
                while (i < subPart.getCount()) {
                    this.retrieveAllParts((Part)subPart.getBodyPart(i));
                    ++i;
                }
            } else if (part.isMimeType("text/plain")) {
                if (part.getFileName() == null) {
                    this.bodyText = (String)part.getContent();
                } else {
                    this.addAttach(part);
                }
            } else {
                this.addAttach(part);
            }
        }
        catch (MessagingException me) {
            me.printStackTrace();
            throw new IncorrectData(me.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new HandleException((Throwable)ioe);
        }
    }

    private void addAttach(Part part) throws MessagingException {
        AttachmentDTO newAttach = new AttachmentDTO();
        String fileName = null;
        byte[] rawData = null;
        try {
            fileName = part.getFileName();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (fileName == null) {
            return;
        }
        try {
            fileName = MimeUtility.decodeText((String)fileName);
            InputStream bio = part.getInputStream();
            ByteArrayOutputStream boo = new ByteArrayOutputStream();
            byte[] buf = new byte[81920];
            int len = buf.length;
            while (len == buf.length) {
                len = bio.read(buf);
                if (len < 0) break;
                try {
                    boo.write(buf, 0, len);
                }
                catch (IndexOutOfBoundsException e) {
                    Log.error((String)"", (Throwable)e);
                }
            }
            rawData = boo.toByteArray();
        }
        catch (UnsupportedEncodingException bio) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        String string = fileName;
        Pop3MailStoreImpl.debug_aroundBody13$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_6);
        if (this.attach == null) {
            this.attach = new ArrayList();
        }
        newAttach.setFileName(fileName);
        newAttach.setFileBody(rawData);
        this.attach.add(newAttach);
    }

    private static final /* synthetic */ void debug_aroundBody0(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody12(Pop3MailStoreImpl pop3MailStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody13$advice(Pop3MailStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Pop3MailStoreImpl.java", Class.forName("jp.co.connectone.eai.pop3.store.Pop3MailStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 42);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 117);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 164);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 189);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 370);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 385);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 461);
    }
}

