/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exchews.ews;

import com.microsoft.schemas.exchange.services._2006.types.SearchExpressionType;
import com.microsoft.schemas.exchange.services._2006.types.UnindexedFieldURIType;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import jp.co.connectone.eai.exchews.ews.EWSSearchOperator;
import jp.co.connectone.eai.exchews.ews.EWSSearchType;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.store.ISearchCondition;

public class EWSSearchCondition
implements ISearchCondition {
    private String name;
    private UnindexedFieldURIType field;
    private Object value;
    private EWSSearchType type;
    private EWSSearchOperator operator;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EWSSearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EWSSearchOperator operator) {
        this.operator = operator;
    }

    public EWSSearchType getType() {
        return this.type;
    }

    public void setType(EWSSearchType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value != null && !(value instanceof String) && !(value instanceof Date)) {
            throw new IllegalArgumentException("value must be an instance of String/Date");
        }
        this.value = value;
    }

    public EWSSearchCondition(String name, EWSSearchType type, Object value, EWSSearchOperator operator) throws IllegalArgumentException {
        this.setName(name);
        this.setType(type);
        this.setValue(value);
        this.setOperator(operator);
    }

    public EWSSearchCondition(UnindexedFieldURIType field, EWSSearchType type, Object value, EWSSearchOperator operator) throws IllegalArgumentException {
        this.setField(field);
        this.setType(type);
        this.setValue(value);
        this.setOperator(operator);
    }

    public JAXBElement<? extends SearchExpressionType> generateSearchExpression() throws HandleException {
        JAXBElement<? extends SearchExpressionType> exp = null;
        String strValue = "";
        switch (this.type) {
            case TYPE_STRING: {
                if (this.value instanceof String) {
                    strValue = (String)this.value;
                    break;
                }
                throw new IncorrectData("value not maches with type.");
            }
            case TYPE_INTEGER: {
                if (this.value instanceof Integer) {
                    strValue = ((Integer)this.value).toString();
                    break;
                }
                throw new IncorrectData("value not maches with type.");
            }
            case TYPE_DATETIME_SZ: {
                if (this.value instanceof Date) {
                    strValue = ExchEWSTranslator.javaDate2EWSDateStr((Date)this.value);
                    break;
                }
                throw new IncorrectData("value not maches with type.");
            }
            case TYPE_DATE_0000: {
                if (this.value instanceof Date) {
                    strValue = ExchEWSTranslator.javaDate2EWSDateStr_DateTop((Date)this.value);
                    break;
                }
                throw new IncorrectData("value not maches with type.");
            }
            case TYPE_DATE_2359: {
                if (this.value instanceof Date) {
                    strValue = ExchEWSTranslator.javaDate2EWSDateStr_DateEnd((Date)this.value);
                    break;
                }
                throw new IncorrectData("value not maches with type.");
            }
        }
        switch (this.operator) {
            case OP_EQUALS: {
                exp = ExchEWSTranslator.createIsEqualTo(this.field, strValue);
                break;
            }
            case OP_BIG_EQUAL: {
                exp = ExchEWSTranslator.createIsGreaterThanOrEqualTo(this.field, strValue);
                break;
            }
            case OP_SMALL_EQUAL: {
                exp = ExchEWSTranslator.createIsLessThanOrEqualTo(this.field, strValue);
                break;
            }
        }
        return exp;
    }

    public UnindexedFieldURIType getField() {
        return this.field;
    }

    public void setField(UnindexedFieldURIType field) {
        this.field = field;
    }
}

