/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.exch2k.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jp.co.connectone.eai.exch2k.dav.DavSearchCondition;
import jp.co.connectone.eai.exch2k.dav.DavSearchOperator;
import jp.co.connectone.eai.exch2k.dav.DavSearchType;
import jp.co.connectone.eai.exch2k.log.LogAspect;
import jp.co.connectone.eai.exch2k.store.EAIExch2kBase;
import jp.co.connectone.eai.exch2k.store.Exch2kDatabaseIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kFolderIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kObjectIndex;
import jp.co.connectone.eai.exch2k.store.Exch2kServiceInfo;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.StoreNotFound;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.DatabaseMetadata;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchConditionElement;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SearchCondition;
import jp.co.connectone.store.SearchConditionCollection;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.client.AddressBookSearchCondition;
import jp.co.connectone.store.pim.BasicAddressDTO;
import jp.co.connectone.store.pim.IAddressBookStore;
import jp.co.connectone.store.pim.IAddressDTO;
import jp.co.connectone.user.IAccountData;
import jp.co.connectone.user.PasswordBasedAccountDataImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Exch2kAddressBookStoreImpl
extends EAIExch2kBase
implements IAddressBookStore {
    private static final String DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT = "\u9023\u7d61\u5148";
    private IFolderIndex addressBookElement = new Exch2kFolderIndex("\u9023\u7d61\u5148");
    public static final IStoreID storeID;
    public static final String storeName = "Exchange2K address book store";
    protected static final Vector<String> fList;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Exch2kAddressBookStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(Exch2kAddressBookStoreImpl.class.getName());
        fList = new Vector();
        fList.add("DAV:id");
        fList.add("DAV:href");
        fList.add("DAV:displayname");
        fList.add("urn:schemas:httpmail:subject");
        fList.add("urn:schemas:contacts:fileas");
        fList.add("urn:schemas:contacts:account");
        fList.add("urn:schemas:contacts:sn");
        fList.add("urn:schemas:contacts:givenName");
        fList.add("urn:schemas:contacts:email1");
        fList.add("urn:schemas:contacts:email2");
        fList.add("urn:schemas:contacts:email3");
        fList.add("urn:schemas:contacts:telephoneNumber");
        fList.add("urn:schemas:contacts:homePhone");
        fList.add("urn:schemas:contacts:mobile");
        fList.add("urn:schemas:contacts:o");
        fList.add("urn:schemas:contacts:workaddress");
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        return super.getServiceInfo(storeID, storeName, serviceData);
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new Exch2kServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    private IAddressDTO populateAddressDTO(HashMap<String, ?> itemList) {
        BasicAddressDTO l_objIAddressDTO = new BasicAddressDTO();
        l_objIAddressDTO.setTid((String)itemList.get("id"));
        l_objIAddressDTO.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("href")));
        l_objIAddressDTO.setFirstName((String)itemList.get("givenName"));
        l_objIAddressDTO.setFamilyName((String)itemList.get("sn"));
        String displayName = (String)itemList.get("fileas");
        if (displayName == null) {
            displayName = (String)itemList.get("displayname");
        }
        String string = "displayName=[" + displayName + "]";
        Exch2kAddressBookStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
        l_objIAddressDTO.setDisplayName(displayName);
        String email = null;
        Vector<String> v = new Vector<String>();
        email = (String)itemList.get("email1");
        if (email != null) {
            v.add(email);
        }
        if ((email = (String)itemList.get("email2")) != null) {
            v.add(email);
        }
        if ((email = (String)itemList.get("email3")) != null) {
            v.add(email);
        }
        email = (String)itemList.get("email1");
        int l = v.size();
        int i = 0;
        while (i < l) {
            String tmp = (String)v.get(i);
            if (tmp.startsWith("SMTP:")) {
                email = tmp.substring(5);
                break;
            }
            ++i;
        }
        l_objIAddressDTO.setEmail(email);
        l_objIAddressDTO.setCompanyPhone((String)itemList.get("telephoneNumber"));
        l_objIAddressDTO.setHomePhone((String)itemList.get("homePhone"));
        l_objIAddressDTO.setMobilePhone((String)itemList.get("mobile"));
        l_objIAddressDTO.setCompanyName((String)itemList.get("o"));
        l_objIAddressDTO.setCompanyAddress((String)itemList.get("workaddress"));
        return l_objIAddressDTO;
    }

    private IAddressDTO populateAddressDTO2(HashMap<String, String> itemList) {
        String streetAddress;
        String l;
        BasicAddressDTO l_objIAddressDTO = new BasicAddressDTO();
        String tid = itemList.get("userPrincipalName");
        if (tid == null) {
            tid = "";
        }
        l_objIAddressDTO.setTid(tid.replaceAll("@", "."));
        l_objIAddressDTO.setOid((IObjectIndex)new Exch2kObjectIndex(itemList.get("sAMAccountName")));
        l_objIAddressDTO.setFirstName(itemList.get("givenName"));
        l_objIAddressDTO.setFamilyName(itemList.get("sn"));
        l_objIAddressDTO.setEmail(itemList.get("mail"));
        l_objIAddressDTO.setCompanyPhone(itemList.get("telephoneNumber"));
        l_objIAddressDTO.setHomePhone(itemList.get("homePhone"));
        l_objIAddressDTO.setMobilePhone(itemList.get("mobile"));
        l_objIAddressDTO.setCompanyName(itemList.get("company"));
        l_objIAddressDTO.setDisplayName(itemList.get("displayName"));
        String string = "displayName=" + itemList.get("displayName");
        Exch2kAddressBookStoreImpl.debug_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        String st = itemList.get("st");
        if (st == null) {
            st = "";
        }
        if ((l = itemList.get("l")) == null) {
            l = "";
        }
        if ((streetAddress = itemList.get("streetAddress")) == null) {
            streetAddress = "";
        }
        l_objIAddressDTO.setCompanyAddress(String.valueOf(st) + l + streetAddress);
        return l_objIAddressDTO;
    }

    public IObjectIndex createNewAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO IAddressDTO2) throws IncorrectStore, ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new HandleException("not yet implemented");
    }

    public IAddressDTO[] getAddressBookItems(IAccountData acc, ISearchDestination dest) throws IncorrectData, StoreNotFound, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        if (dest.getDatabase() != null) {
            throw new HandleException("get all datas from ActiveDirectory is not supported.");
        }
        Vector<HashMap<String, Object>> col = super.getList(this.getDefaultUserAddressBook(), Exch2kAddressBookStoreImpl.getDefaultFieldList());
        int len = col.size();
        IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[len];
        int i = 0;
        while (i < len) {
            l_IAddressDTOArray[i] = this.populateAddressDTO(col.elementAt(i));
            ++i;
        }
        return l_IAddressDTOArray;
    }

    public IAddressDTO getAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectStore, IncorrectData, HandleException {
        IAddressDTO l_objIAddressDTO = null;
        String string = "getAddressBookItem::oid=" + oid;
        Exch2kAddressBookStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        if (dest.getDatabase() != null) {
            SearchConditionCollection conds = new SearchConditionCollection();
            AddressBookSearchCondition cond = new AddressBookSearchCondition((ISearchType)AddressBookSearchCondition.CONDITION.TYPE_ACCOUNTNAME, (Object)oid.getIndex().toString());
            conds.add((ISearchConditionElement)cond);
            List<HashMap<String, String>> col = this.searchUserFromActiveDirectory(conds);
            if (col.size() == 0) {
                throw new DataNotFound("account that has sAMAAccountName=" + oid.getIndex().toString() + " not found.");
            }
            l_objIAddressDTO = this.populateAddressDTO2(col.get(0));
        } else {
            HashMap<String, Object> addr = super.getProps(oid.getIndex().toString(), Exch2kAddressBookStoreImpl.getDefaultFieldList());
            l_objIAddressDTO = this.populateAddressDTO(addr);
        }
        return l_objIAddressDTO;
    }

    public IObjectIndex updateAddressBookItem(IAccountData acc, ISearchDestination dest, IAddressDTO IAddressDTOObj) throws NoSuchRights, ServerDown, DataNotFound, IncorrectStore, IncorrectData, UpdateFailed, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void deleteAddressBookItem(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws ServerDown, NoSuchRights, DataNotFound, IncorrectData, HandleException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public IAddressDTO[] searchAddressBook(IAccountData acc, ISearchFormula conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        if (conds.getDest().getDatabase() != null) {
            String string = "search from active directory";
            Exch2kAddressBookStoreImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
            return this.searchActiveDirectory(acc, conds.getSearchConditions());
        }
        if (DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT.equalsIgnoreCase(conds.getDest().getFolder().getIndex().toString())) {
            String string = "search from personal address book";
            Exch2kAddressBookStoreImpl.debug_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
            return this.searchPersonalAddressbook(acc, DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT, conds.getSearchConditions());
        }
        throw new HandleException("Illegal strDBName");
    }

    private IAddressDTO[] searchActiveDirectory(IAccountData acc, SearchConditionCollection conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        List<HashMap<String, String>> col = this.searchUserFromActiveDirectory(conds);
        int len = col.size();
        String string = "results(searchUserFromActiveDirectory):" + len;
        Exch2kAddressBookStoreImpl.debug_aroundBody11$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_5);
        IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[]{};
        ArrayList<IAddressDTO> ar = new ArrayList<IAddressDTO>();
        int i = 0;
        while (i < len) {
            block3: {
                IAddressDTO dto = null;
                try {
                    dto = this.populateAddressDTO2(col.get(i));
                }
                catch (Exception e) {
                    Log.error((String)("IAddressDTO populate error:Igunore address data no " + i), (Throwable)e);
                    break block3;
                }
                ar.add(dto);
            }
            ++i;
        }
        l_IAddressDTOArray = ar.toArray(l_IAddressDTOArray);
        return l_IAddressDTOArray;
    }

    private IAddressDTO[] searchPersonalAddressbook(IAccountData acc, String strDBName, SearchConditionCollection conds) throws IncorrectStore, ServerDown, NoSuchRights, StoreNotFound, DataNotFound, IncorrectData, HandleException {
        this.setAccountData((PasswordBasedAccountDataImpl)acc);
        Vector<HashMap<String, String>> col = super.search(strDBName, Exch2kAddressBookStoreImpl.getDefaultFieldList(), conds);
        int len = col.size();
        IAddressDTO[] l_IAddressDTOArray = new IAddressDTO[]{};
        ArrayList<IAddressDTO> ar = new ArrayList<IAddressDTO>();
        int i = 0;
        while (i < len) {
            block3: {
                IAddressDTO dto = null;
                try {
                    dto = this.populateAddressDTO(col.elementAt(i));
                }
                catch (Exception e) {
                    Log.error((String)("IAddressDTO populate error:Igunore address data no " + i), (Throwable)e);
                    break block3;
                }
                ar.add(dto);
            }
            ++i;
        }
        l_IAddressDTOArray = ar.toArray(l_IAddressDTOArray);
        return l_IAddressDTOArray;
    }

    @Override
    protected DavSearchCondition convertCondition(SearchCondition src) throws HandleException {
        ISearchType cond = src.getType();
        DavSearchType type = DavSearchType.TYPE_STRING;
        String name = null;
        if (cond == AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME) {
            name = "urn:schemas:contacts:fileas";
        } else if (cond == AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME) {
            name = "urn:schemas:contacts:givenName";
        } else if (cond == AddressBookSearchCondition.CONDITION.TYPE_LASTNAME) {
            name = "urn:schemas:contacts:sn";
        } else {
            throw new HandleException("Condition type not supported");
        }
        DavSearchCondition dst = new DavSearchCondition(name, type, src.getValue(), DavSearchOperator.OP_FORWARD_LIKE);
        return dst;
    }

    protected static Vector<String> getDefaultFieldList() {
        return fList;
    }

    protected IFolderIndex getDefaultUserAddressBook() {
        return new Exch2kFolderIndex(DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT);
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteAddressBookItem(acc, dest, oid);
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        return this.getAddressBookItems(acc, dest);
    }

    public FolderMetadata[] getFolderList(IAccountData arg0, ISearchDestination dest) throws Exception {
        throw new UnsupportedOperationException("get folder list on NotesAddressBook not supported.");
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getAddressBookItem(acc, dest, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula col) throws Exception {
        return this.searchAddressBook(acc, col);
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date searchDate) throws Exception {
        throw new UnsupportedOperationException("searchByDate on NotesAddressBook not supported.");
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject address) throws Exception {
        IObjectIndex rc = null;
        rc = address.isNew() ? this.createNewAddressBookItem(acc, dest, (IAddressDTO)address) : this.updateAddressBookItem(acc, dest, (IAddressDTO)address);
        return rc;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        super.setAccountData((PasswordBasedAccountDataImpl)acc);
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        switch (type) {
            case 1: {
                folder = (IFolderIndex)this.populateFolder(this.addressBookElement).getOid();
                break;
            }
            case 2: {
                db = (IDatabaseIndex)this.populateADDatabase().getOid();
                break;
            }
            default: {
                throw new IncorrectData("illegal folderType");
            }
        }
        return new BasicSearchDestination(db, folder);
    }

    public DatabaseMetadata populateADDatabase() {
        DatabaseMetadata db = new DatabaseMetadata();
        db.setServerName(super.getAdAddress());
        Exch2kDatabaseIndex oid = new Exch2kDatabaseIndex("connector_exch2k:ActiveDirectory." + super.getAdAddress());
        db.setOid((IObjectIndex)oid);
        HashMap h = db.getFieldSet();
        h.put("oid", oid);
        return db;
    }

    @Override
    protected String getElmentName() {
        return DEFAULT_EXCHANGE_ADDRESSBOOK_PATH_ELEMENT;
    }

    private static final /* synthetic */ void debug_aroundBody0(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody8(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody9$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody10(Exch2kAddressBookStoreImpl exch2kAddressBookStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody11$advice(Exch2kAddressBookStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_exch2k_log_LogAspect$jp_co_connectone_eai_exch2k_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Exch2kAddressBookStoreImpl.java", Class.forName("jp.co.connectone.eai.exch2k.store.Exch2kAddressBookStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 55);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 105);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 147);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 197);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 201);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 215);
    }
}

