/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import jp.co.connectone.common.IPropertyHandler;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.service.IServiceInfoRawdataProvider;
import jp.co.connectone.service.SimpleServiceInfoRawData;

public class PropertyBasedServiceInfoRawdataProvider
implements IServiceInfoRawdataProvider {
    protected Properties prop;

    protected PropertyBasedServiceInfoRawdataProvider(Properties src) {
        if (src == null) {
            throw new NullPointerException("src must not be null");
        }
        this.prop = src;
    }

    public static IServiceInfoRawdataProvider getInstance(String domainName) throws Exception {
        Properties src = null;
        Properties initArgs = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.service." + domainName);
        IPropertyHandler handler = PropertyHandlerBaseImpl.getInstance(initArgs.getProperty("PropertyHandler"));
        handler.setInitArgs(initArgs);
        try {
            src = handler.getProperties("jp.co.connectone.service.PropertyBasedServiceInfoRawdataProvider." + domainName);
        }
        catch (DataNotFound dnf) {
            throw dnf;
        }
        catch (Exception e) {
            Log.error("", e);
        }
        return new PropertyBasedServiceInfoRawdataProvider(src);
    }

    @Override
    public IServiceInfoRawData getServiceInfoRawData(String serviceCode) throws HandleException {
        SimpleServiceInfoRawData data = new SimpleServiceInfoRawData();
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("serviceCode", serviceCode);
        for (Map.Entry<Object, Object> o : this.prop.entrySet()) {
            String name = (String)o.getKey();
            if (name.indexOf(serviceCode) < 0) continue;
            Object value = o.getValue();
            h.put(name.substring(serviceCode.length() + 1), value);
        }
        try {
            data.setFieldSet(h);
        }
        catch (IllegalAccessException iae) {
            Log.error("IllegalAccessException on SimpleServiceInfoRawData.setFieldSet(HashMap).", iae);
            throw new HandleException(iae.getMessage());
        }
        return data;
    }

    @Override
    public String getStoreClientName(String serviceCode) throws HandleException {
        return this.prop.getProperty(String.valueOf(serviceCode) + ".store");
    }

    public String[] getServieCodeList() throws HandleException {
        HashSet<String> hash = new HashSet<String>();
        for (Map.Entry<Object, Object> o : this.prop.entrySet()) {
            String name = (String)o.getKey();
            String serviceCode = name.substring(0, name.indexOf(46));
            hash.add(serviceCode);
        }
        return hash.toArray(new String[0]);
    }
}

