package jp.co.connectone.webproxy.ui.logic;

import java.util.*;

import jp.co.connectone.eai.exch2k.store.*;
import jp.co.connectone.eai.exch2k.user.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.client.*;
import jp.co.connectone.user.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.webapps.struts.*;
import jp.co.connectone.webproxy.ui.DTOParseHelper.WebExch2kScheduleParseHelper;
import jp.co.connectone.common.PropertyHandlerBaseImpl;


/**
 * @author amanot
 *
 */
public class Controler
{
	public static final int COMMON_ADDRESSBOOK = 1;
	public static final int PERSONAL_ADDRESSBOOK = 2;
	public static final int LISTSIZE=50;
	public static final int MAXCHAR=5000;
	private static Controler theSingleton=null;
	private static Properties prop=null;
	private static String server="127.0.0.1";
	private Controler(){};

	protected Exch2kAccountData setUpServiceInfo(String strUser,String strPassword) throws Exception
	{
		Exch2kAccountData acc;
		Exch2kMailStoreImpl aEAIPop3ImplObj = new Exch2kMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),strUser);
		Exch2kServiceInfo si = (Exch2kServiceInfo)aEAIPop3ImplObj.getServiceInfo();
		si.setServerAddress(server);
		acc = new Exch2kAccountData(uid,si);
		acc.setUserID(strUser);
		acc.setPassword(strPassword);
		return acc;
	}

	public static Controler getInstance()
	{
		if (theSingleton==null) {
			theSingleton = new Controler();
		}
		if (prop==null) {
			try {
				prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.webproxy.ui.logic.Controler");
				server = prop.getProperty("server");
			}
			catch (Exception e) {
				// level ERROR : install or setting
				Log.fatal("",e);
			}
		}
		return theSingleton;
	}
	public boolean checkServerAccount(IUser user,String id,String password) {
		ISearchDestination	dest = null;
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
			dest = iStore.getPresetDestination(acc, IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		try{
			iStore.getFolderList(acc, dest);
			return true;
		} catch(NullPointerException e){
			//On the first registration
			return true;
		} catch (Exception e) {
			Log.error("",e);
			return false;
		}
	}
	
	public StrutsArrayList searchAddress(String id,String password,String name,int mode) throws Exception
	{

		IAccountData acc= null;
		IAddressBookStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kAddressBookStoreImpl();
		}
		catch (Exception e) {
			//e.Log.error("",e);
		}
		SearchConditionCollection conds = new SearchConditionCollection();
		AddressBookSearchCondition cond = new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME,name);
		ISearchDestination dest = null;
		conds.add(cond);
		switch (mode) {
		case COMMON_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
			break;
		case PERSONAL_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
			break;
		default:
			throw new IllegalArgumentException("searchAddress:unsupported mode("+mode+")");
		}
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = iStore.searchAddressBook(acc,formula);
		return populateList(rc);
	}
	
	public StrutsArrayList getMailList(String id,String password,IFolderIndex fid,Date date) throws Exception
	{
		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMailStoreImpl();
		}
		catch (Exception e) {
			//e.Log.error("",e);
		}
		if (fid==null) {
			IRecordObject x = iStore.getFolderIndexFromString(null);
			fid = (IFolderIndex)x.getOid();
		}
		ISearchDestination dest = new BasicSearchDestination(null,fid);
		IMailDTO[] mailList = (IMailDTO[])iStore.getMailsByDate(acc,dest,date);
		
		return populateList(mailList);
	}
	
	public StrutsArrayList getScheduleList(String id,String password,Date date) throws Exception
	{
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		IScheduleDTO[] scheList = (IScheduleDTO[])iStore.getSchedulesByDate(acc,date);
		
		return populateList(scheList);
	}
	
	public StrutsArrayList getOtheronesScheduleList(String id,String password,IObjectIndex idToSee, Date date) throws Exception
	{
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,idToSee);
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE,date);
		conds.add(cond);
		ISearchDestination dest = iStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IScheduleDTO[] scheList = iStore.searchSchedules(acc,formula);
		
		return populateOtherList(scheList);
	}
	
	public StrutsArrayList getTaskList(String id,String password) throws Exception
	{
		IAccountData acc= null;
		ITaskStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kTaskStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		ITaskDTO[] taskList = (ITaskDTO[])iStore.getAllTasks(acc);

		return populateList(taskList);
	}
	
	public StrutsArrayList getMemoList(String id,String password) throws Exception
	{
		IAccountData acc= null;
		IMemoStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMemoStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		IMemoDTO[] memoList = (IMemoDTO[])iStore.getAllMemos(acc);
		
		return populateList(memoList);
	}
	
	protected StrutsArrayList populateList(IRecordObject[] src) throws Exception
	{
		Collection<IRecordObject> col = Arrays.asList(src);
		Iterator<IRecordObject> it = col.iterator();
		StrutsArrayList rc = new StrutsArrayList();
		Log.debug("listSize="+LISTSIZE);
		try {
			rc.setPageSize(LISTSIZE);
		}
		catch (NumberFormatException e) {
			Log.error("warn:error at getting listsize fron user",e);
		}
		int bodyLength = MAXCHAR;
		boolean duplicationFlg = false;
		while (it.hasNext()) {
			IRecordObject o = it.next();
			duplicationFlg = false;
			if (o instanceof IMailDTO) {
				IMailDTO dto = (IMailDTO)o;
				WebMailParseHelper pdto = new WebMailParseHelper(new MailParseHelper(dto));
				if(dto instanceof Exch2kMailDTO)pdto.setRead(((Exch2kMailDTO)dto).isRead());
				pdto.setBodyLength(bodyLength);
				o = pdto;
			}
			else if (o instanceof IScheduleDTO) {
				IScheduleDTO dto = (IScheduleDTO)o;
				WebScheduleParseHelper pdto = new WebScheduleParseHelper(new ScheduleParseHelper(dto));
				pdto.setBodyLength(bodyLength);
				o = pdto;
				if(dto instanceof Exch2kScheduleDTO){
					Exch2kScheduleDTO exchDto = (Exch2kScheduleDTO)dto;
					String rrule = exchDto.getRrule();
					//IȃACẽ}X^rruleɒlݒ肳Ă
					if(rrule != null && !"".equals(rrule)){
						//}X^łlistɂ͒ǉȂ
						duplicationFlg = true;
					}
				}
			}
			else if (o instanceof IAddressDTO) {
				IAddressDTO dto = (IAddressDTO)o;
				WebAddressParseHelper pdto = new WebAddressParseHelper(new AddressParseHelper(dto));
				o = pdto;
			}
			else if (o instanceof ITaskDTO) {
				ITaskDTO dto = (ITaskDTO)o;
				WebTaskParseHelper pdto = new WebTaskParseHelper(new TaskParseHelper(dto));
				pdto.setBodyLength(bodyLength);
				o = pdto;
			}
			else if (o instanceof IMemoDTO) {
				IMemoDTO dto = (IMemoDTO)o;
				WebMemoParseHelper pdto = new WebMemoParseHelper(new MemoParseHelper(dto));
				pdto.setBodyLength(bodyLength);
				o = pdto;
			}
			if(!duplicationFlg){
				rc.add(o);
			}
		}
		
Log.debug("wrappedResult:size="+rc.size());
		return rc;
	}
	
	protected StrutsArrayList populateOtherList(IRecordObject[] src) throws Exception
	{
		Collection<IRecordObject> col = Arrays.asList(src);
		Iterator<IRecordObject> it = col.iterator();
		StrutsArrayList rc = new StrutsArrayList();
		Log.debug("listSize="+LISTSIZE);
		try {
			rc.setPageSize(LISTSIZE);
		}
		catch (NumberFormatException e) {
			Log.error("warn:error at getting listsize fron user",e);
		}
		while (it.hasNext()) {
			Exch2kScheduleDTO dto = (Exch2kScheduleDTO)it.next();
			String s = (String)dto.getFieldSet().get("sensitivity");
			if (s.equalsIgnoreCase("0")) {
				WebScheduleParseHelper pdto = new WebScheduleParseHelper(new ScheduleParseHelper(dto));
				String rrule = dto.getRrule();
				// IȃACẽ}X^rruleɒlݒ肳Ă
				if(rrule == null || "".equals(rrule)){
					//}X^łlistɂ͒ǉȂ
					rc.add(pdto);
				}
			}
		}
		
Log.debug("wrappedResult:size="+rc.size());
		return rc;
	}
	
	public StrutsArrayList getMailFolderList(String id,String password) throws Exception
	{
		IAccountData acc= null;
		IMailStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		ISearchDestination dest = iStore.getPresetDestination(acc,Exch2kMailStoreImpl.DEST_TYPE_DEFAULT_MAIL_FOLDER);

		FolderMetadata[] folderList = iStore.getFolderList(acc,dest);
		if (folderList==null) {
			dest = iStore.getPresetDestination(acc,Exch2kMailStoreImpl.DEST_TYPE_OLD_MAIL_FOLDER);

			folderList = iStore.getFolderList(acc,dest);
			
		}
		return populateList(folderList);
	}
	
	public WebAddressParseHelper getAddressBookItem(String id,String password,IObjectIndex idx,int mode) throws Exception
	{
		ISearchDestination dest = null;
		IAccountData acc= null;
		IAddressBookStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kAddressBookStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		switch (mode) {
		case COMMON_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
			break;
		case PERSONAL_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
			break;
		default:
			throw new IllegalArgumentException("getAddressBookItem:unsupported mode("+mode+")");
		}
		WebAddressParseHelper ph = new WebAddressParseHelper(new AddressParseHelper(iStore.getAddressBookItem(acc,dest,idx)));

		return ph;
	}
	
	public WebMailParseHelper getMail(String id,String password,IObjectIndex idx) throws Exception
	{
		IAccountData acc= null;
		IMailStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		IMailDTO mail = iStore.getMail(acc,null,idx);
		WebMailParseHelper ph = new WebMailParseHelper(new MailParseHelper(mail));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}
	
	public void delete(String id,String password,IObjectIndex idx) throws Exception
	{
		IAccountData acc= null;
		IMailStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		iStore.delete(acc,null,idx);
	}
	
	public WebMemoParseHelper getMemo(String id,String password,IObjectIndex idx) throws Exception
	{
		IAccountData acc= null;
		IMemoStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMemoStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		IMemoDTO memo = iStore.getMemoByOID(acc,idx);
		WebMemoParseHelper ph = new WebMemoParseHelper(new MemoParseHelper(memo));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}
	
	public WebTaskParseHelper getTask(String id,String password,IObjectIndex idx) throws Exception
	{
		IAccountData acc= null;
		ITaskStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kTaskStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		ITaskDTO task = iStore.getTaskByOID(acc,idx);
		WebTaskParseHelper ph = new WebTaskParseHelper(new TaskParseHelper(task));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}
	
	public WebExch2kScheduleParseHelper getOtheronesSchedule(String id,String password,IObjectIndex idToSee,IObjectIndex idx) throws Exception
	{
Log.debug("getOtheronesSchedule:idTooSee="+idToSee+"oid="+idx+"("+idx.getIndex().toString()+")");
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,idToSee);
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_OID,idx);
		conds.add(cond);
		ISearchDestination dest = iStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IScheduleDTO[] scheList = iStore.searchSchedules(acc,formula);
		WebExch2kScheduleParseHelper ph = new WebExch2kScheduleParseHelper(new ScheduleParseHelper(scheList[0]));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}
	
	public WebExch2kScheduleParseHelper getSchedule(String id,String password,IObjectIndex idx) throws Exception
	{
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		IScheduleDTO sche = iStore.getSchedule(acc,idx);
		WebExch2kScheduleParseHelper ph = new WebExch2kScheduleParseHelper(new ScheduleParseHelper(sche));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}

	public StrutsArrayList getFolderList() throws Exception
	{
		StrutsArrayList list = null;
		
		return list;
	}
	
	public void sendMail(String id,String password,IMailDTO mail) throws Exception
	{
		IAccountData acc= null;
		IMailStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		
		iStore.sendMail(acc,mail);
		
	}
	
	private void setConfirm(Exch2kScheduleDTO dto)
	{
		MailAddress tmp[] = dto.getTo();
		if (tmp != null) {
			if (tmp.length>0) {
				dto.setMeetingstatus("CONFIRMED");
			}
		}
		tmp = dto.getCc();
		if (tmp != null) {
			if (tmp.length>0) {
				dto.setMeetingstatus("CONFIRMED");
			}
		}
		tmp = dto.getBcc();
		if (tmp != null) {
			if (tmp.length>0) {
				dto.setMeetingstatus("CONFIRMED");
			}
		}
	}

	public void saveSchedule(String id,String password,IScheduleDTO sche) throws Exception
	{
		if (sche.isNew()) {
			setConfirm((Exch2kScheduleDTO)sche);
		}
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		
		iStore.write(acc,null,sche);
	}

	public void saveTask(String id,String password,ITaskDTO task) throws Exception
	{
		IAccountData acc= null;
		ITaskStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kTaskStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		iStore.write(acc,null,task);
	}

	public void saveMemo(String id,String password,IMemoDTO memo) throws Exception
	{
		IAccountData acc= null;
		IMemoStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Exch2kMemoStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		iStore.write(acc,null,memo);
	}
	
	public boolean isValidIPAddress(String IPAddress)
	{
		String allowedIP = prop.getProperty("allowedIPAddress","127.0.0.1");
		if (allowedIP.equalsIgnoreCase(IPAddress)) return true;
		return false;
	}
}
