
package jp.co.connectone.webproxy.ui.logic;

import java.util.*;

import jp.co.connectone.eai.pop3.store.*;
import jp.co.connectone.eai.pop3.user.*;
import jp.co.connectone.eai.smtp.store.*;
import jp.co.connectone.eai.smtp.user.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.user.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.webapps.struts.*;
import jp.co.connectone.common.PropertyHandlerBaseImpl;


/**
 * @author amanot
 *
 */
public class Controler
{
	public static final int COMMON_ADDRESSBOOK = 1;
	public static final int PERSONAL_ADDRESSBOOK = 2;
	public static final int LISTSIZE=50;
	public static final int MAXCHAR=5000;
	private static Controler theSingleton=null;
	private static Properties prop=null;
	private static String server="127.0.0.1";
	private Controler(){};
	
	protected Pop3AccountData setUpServiceInfo(String strUser,String strPassword) throws Exception
	{
		Pop3AccountData acc;
		Pop3MailStoreImpl aEAIPop3ImplObj = new Pop3MailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),strUser);
		Pop3ServiceInfo si = (Pop3ServiceInfo)aEAIPop3ImplObj.getServiceInfo();
		si.setServerAddress(server);
		acc = new Pop3AccountData(uid,si);
		acc.setUserID(strUser);
		acc.setPassword(strPassword);
		return acc;
	}
	
	protected SmtpAccountData setUpServiceInfo2(String strUser,String strPassword) throws Exception
	{
		SmtpAccountData acc;
		SmtpMailStoreImpl aEAISmtpImplObj = new SmtpMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),strUser);
		SmtpServiceInfo si = (SmtpServiceInfo)aEAISmtpImplObj.getServiceInfo();
		si.setServerAddress(server);
		acc = new SmtpAccountData(uid,si);
		acc.setUserID(strUser);
		acc.setPassword(strPassword);
		return acc;
	}

	public static Controler getInstance()
	{
		if (theSingleton==null) {
			theSingleton = new Controler();
		}
		if (prop==null) {
			try {
				prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.webproxy.ui.logic.Controler");
				server = prop.getProperty("server");
			}
			catch (Exception e) {
				// level ERROR : install or setting
				Log.fatal("",e);
			}
		}
		return theSingleton;
	}
	
	public boolean checkServerAccount(String id,String password)
	{
		ISearchDestination	dest = null;
		IAccountData acc= null;
		Pop3MailStoreImpl iStore = null;

		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Pop3MailStoreImpl();
			dest = iStore.getPresetDestination(acc, Pop3MailStoreImpl.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		try{
			iStore.getHeadersByDate(acc,dest, new Date());
			return true;
		} catch(NullPointerException e){
			//On the first registration
			return true;
		} catch (Exception e) {
			Log.error("",e);
			return false;
		}
	}

	public StrutsArrayList getMailList(String id,String password,Date date) throws Exception
	{
		ISearchDestination	dest = null;
		IAccountData acc= null;
		Pop3MailStoreImpl iStore = null;

		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Pop3MailStoreImpl();
			dest = iStore.getPresetDestination(acc, Pop3MailStoreImpl.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		IMailDTO[] mailList = (IMailDTO[])iStore.getMailsByDate(acc,dest,date);

		return populateList(mailList);
	}

	protected StrutsArrayList populateList(IRecordObject[] src) throws Exception
	{
		Collection<IRecordObject> col = Arrays.asList(src);
		Iterator<IRecordObject> it = col.iterator();
		StrutsArrayList rc = new StrutsArrayList();

Log.debug("listSize="+LISTSIZE);
		try {
			rc.setPageSize(LISTSIZE);
		}
		catch (NumberFormatException e) {
			Log.error("warn:error at getting listsize fron user",e);
		}
		int bodyLength = MAXCHAR;
		boolean duplicationFlg = false;
		while (it.hasNext()) {
			IRecordObject o = it.next();
			duplicationFlg = false;
			if (o instanceof IMailDTO) {
				IMailDTO dto = (IMailDTO)o;
				WebMailParseHelper pdto = new WebMailParseHelper(new MailParseHelper(dto));
				pdto.setBodyLength(bodyLength);
				o = pdto;
			}
			if(!duplicationFlg){
				rc.add(o);
			}
		}

Log.debug("wrappedResult:size="+rc.size());
		return rc;
	}

	public WebMailParseHelper getMail(String id,String password,IObjectIndex idx) throws Exception
	{
		ISearchDestination	dest = null;
		IAccountData acc= null;
		Pop3MailStoreImpl iStore = null;

		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Pop3MailStoreImpl();
			dest = iStore.getPresetDestination(acc, Pop3MailStoreImpl.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		IMailDTO mail = iStore.getMail(acc, dest, idx);
		WebMailParseHelper ph = new WebMailParseHelper(new MailParseHelper(mail));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}

	public void delete(String id,String password,IObjectIndex idx) throws Exception
	{
		ISearchDestination	dest = null;
		IAccountData acc= null;
		Pop3MailStoreImpl iStore = null;

		try{
			acc = setUpServiceInfo(id,password);
			iStore = new Pop3MailStoreImpl();
			dest = iStore.getPresetDestination(acc, Pop3MailStoreImpl.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		iStore.delete(acc, dest, idx);
	}

	public void sendMail(String id,String password,IMailDTO mail) throws Exception
	{
		IAccountData acc= null;
		SmtpMailStoreImpl iStore = null;

		try{
			acc = setUpServiceInfo2(id,password);
			iStore = new SmtpMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		iStore.sendMail(acc, mail);

	}

	public boolean isValidIPAddress(String IPAddress)
	{
		String allowedIP = prop.getProperty("allowedIPAddress","127.0.0.1");
		if (allowedIP.equalsIgnoreCase(IPAddress)) return true;
		return false;
	}
}
