/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.filters;

import java.io.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.http.*;

import jp.co.connectone.log.Log;

/**
 * @author amanot
 */
public class URLencodeFilter extends BaseFilter implements Filter
{
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
	{
		BufferedTextResponseWrapper responseWrapper = new BufferedTextResponseWrapper(response);

		chain.doFilter(request, responseWrapper);

		Log.debug("content type = "+response.getContentType());
		if (response.getContentType().indexOf("text/html")>=0) {
			String cookielessSessionHtmlText = encodeUrlForAllUrls((HttpServletResponse) response, responseWrapper.getBuffer());

			PrintWriter out = response.getWriter();
			out.print(cookielessSessionHtmlText);
		}
	}

	private static Pattern aHrefPattern = Pattern.compile("(<a(\\s+\\w+(=\"[^\"]*\")*)*(\\s+href=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*/?\\s*>)", Pattern.CASE_INSENSITIVE);

	private static Pattern formActionPattern = Pattern.compile("(<form(\\s+\\w+(=\"[^\"]*\")*)*?(\\s+action=\"))([^\"]+)(\"(\\s+\\w+(=\"[^\"]*\")*)*\\s*>)", Pattern.CASE_INSENSITIVE);

	private String encodeUrlForAllUrls(HttpServletResponse response, CharSequence htmlText)
	{
		Matcher m;
		StringBuffer sb;

		// <a href="...">ϊ
		m = aHrefPattern.matcher(htmlText);
		sb = new StringBuffer();
		while (m.find()) {
			String newHref = m.group(5); // ̌URL`FbNiK{j
			if (newHref.indexOf(':') == -1)
				newHref = response.encodeURL(newHref);
			m.appendReplacement(sb, m.group(1) + newHref + m.group(6));
		}
		m.appendTail(sb);

		// <form action="...">ϊ
		m = formActionPattern.matcher(sb);
		sb = new StringBuffer();
		while (m.find()) {
			String newAction = m.group(5); // ̌URL`FbNiK{j
			if (newAction.indexOf(':') == -1)
				newAction = response.encodeURL(newAction);
			m.appendReplacement(sb, m.group(1) + newAction + m.group(6));
		}
		m.appendTail(sb);

		return new String(sb);
	}

	static class BufferedTextResponseWrapper extends HttpServletResponseWrapper
	{
		private StringWriter writer;

		private PrintWriter pw;

		public BufferedTextResponseWrapper(ServletResponse response)
		{
			super((HttpServletResponse) response);
		}

		public PrintWriter getWriter() throws IOException
		{
			writer = new StringWriter();
			pw = new PrintWriter(writer);
			return pw;
		}

		public StringBuffer getBuffer()
		{
			if (writer==null) {
				try {
					getWriter();
				}
				catch (IOException ioe) {
					Log.error("error on getWriter",ioe);
				}
			}
			pw.flush();
			return writer.getBuffer();
		}
	}
}
