/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.helpers;

import java.net.URLEncoder;

import jp.co.connectone.store.pim.*;

/**
 * @author amanot
 *
 */
public class WebMemoParseHelper extends MemoParseHelper {

/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/*override original helper */
	public void setMemoDTO(IMemoDTO arg0) {
		copy(arg0);
		setBody(extention.formatBody(getBody()));
	}
	
	
	public int getPrevPage()
	{
		return extention.getPrevPage();
	}
	
	public int getNextPage()
	{
		return extention.getNextPage();
	}

	public String getBodyHtml() {
		String rc = super.getBody();
		if (rc == null) return rc;
    	rc.replaceAll("\n","<BR>\n");
    	rc = extention.pagingString(rc);
    	rc = extention.escapeTags(rc);
		rc = extention.formatBody(rc);
		return rc;
	}

	public String getSubject() {
		String rc =  super.getSubject();
		if (rc==null) return "";
		if (rc.length()==0) return "";
		return rc;
	}
	
	
/* added module */
	protected WebParserAggregationBase extention=new WebParserAggregationBase();

	public String getEscapedId()
	{
		String rc = getTid();
		try {rc = URLEncoder.encode(getTid(),"UTF-8");}catch(Exception e){};
		return rc;
	}

	/**
	 * @return bodyLength ߂܂B
	 */
	public int getBodyLength() {
		return extention.getBodyLength();
	}
	/**
	 * @param bodyLength bodyLength ݒB
	 */
	public void setBodyLength(int bodyLength) {
		extention.setBodyLength(bodyLength);
	}
	/**
	 * @return currentPage ߂܂B
	 */
	public int getCurrentPage() {
		return extention.getCurrentPage();
	}
	/**
	 * @param currentPage currentPage ݒB
	 */
	public void setCurrentPage(int currentPage) {
		extention.setCurrentPage(currentPage);
	}
	
	public WebMemoParseHelper(MemoParseHelper org)
	{
		super(org.getMemoDTO());
		super.setTid(""+extention.getNextID());
		
	}
	
	public int getLastPage() {
		return extention.getLastPage(super.getBody());
	}

	public void escapeTags() {
		super.setSubject(extention.escapeTags(super.getSubject()));
		super.setBody(extention.escapeTags(super.getBody()));
	}
}
