/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.notes.store;

import java.util.HashMap;
import jp.co.connectone.store.*;

public class NotesDBFieldSet extends BasicRecordObject
{
	private static final long serialVersionUID = 1L;

	public void setOid(IObjectIndex oid)
	{
		super.setOid(new NotesObjectIndex(oid.getIndex().toString()));
//		this.nid = new NotesObjectIndex(oid.getIndex().toString());
	}

	/**
	 * @param arg0
	 */
	public NotesDBFieldSet(IRecordObject src)
	{
		super(src);
		super.setOid(new NotesObjectIndex(oid.getIndex().toString()));
		caseSensitive = false;
	}

	public NotesDBFieldSet(String nid, HashMap<String,Object> fieldSet)
	{
		oid = new NotesObjectIndex(nid);
		this.fieldSet = fieldSet;
		caseSensitive = false;
	}
	
	public NotesDBFieldSet(NotesObjectIndex nid, HashMap<String,Object> fieldSet)
	{
		oid = nid;
		this.fieldSet = fieldSet;
		caseSensitive = false;
	}
	
	public boolean isNew()
	{
		return (oid==null);
	}

	public NotesDBFieldSet()
	{
		oid = null;
		this.fieldSet = new HashMap<String,Object>();
	}

	public IObjectIndex getOid()
	{
		return oid;
	}

	@SuppressWarnings("unchecked")
	public HashMap<String,Object> getFieldSet()
	{
		return (HashMap<String, Object>) this.fieldSet.clone();
	}

	public void setFieldSet(HashMap<String,Object> fieldSet)
	{
		this.fieldSet = fieldSet;
	}

}
