/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ews;

import java.text.SimpleDateFormat;

/**
 * @author amanot
 *
 */
public class EWSDateFormat extends SimpleDateFormat
{
	private static final long serialVersionUID = 1L;
	public static final int FORMAT_DAV_TZ_MSEC=1;
	public static final int FORMAT_DAV_T_SEC=2;
	public static final int FORMAT_DAV_T_SEC_WITH00HOUR=3;
	public static final int FORMAT_DAV_T_SEC_WITH23HOUR=4;

	public EWSDateFormat()
	{
		setFormatType(FORMAT_DAV_T_SEC);
	}
	
	public EWSDateFormat(int formatType)
	{
		setFormatType(formatType);
	}
	
	public void setFormatType(int formatType)
	{
	    setLenient( false );
	    switch(formatType) {
	    case FORMAT_DAV_TZ_MSEC:
		    applyPattern( "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'" );
		    break;
	    case FORMAT_DAV_T_SEC:
		    applyPattern( "yyyy-MM-dd'T'HH:mm:ss'Z'" );
		    break;
	    case FORMAT_DAV_T_SEC_WITH00HOUR:
		    applyPattern( "yyyy-MM-dd'T'00:00:00'Z'" );
		    break;
	    case FORMAT_DAV_T_SEC_WITH23HOUR:
		    applyPattern( "yyyy-MM-dd'T'23:59:00'Z'" );
		    break;
	    default:
	    	throw new IllegalArgumentException("format type not supported");
	    }
	}
}
