/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.internet.MimeMessage;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.HeaderDTO;
import junit.framework.TestCase;

public class TestPop3ProtocolSocketImpl extends TestCase
{
	Pop3ProtocolSocketImpl pop3;
	@Override
	protected void setUp() throws Exception
	{
		pop3 = (Pop3ProtocolSocketImpl) Pop3ProtocolSocketImpl.getInstance();
	}

	public void testDoQuit() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doQuit();
		pop3.disconnect();
	}

	public void testDoUser() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doQuit();
		pop3.disconnect();
	}

	public void testDoPass() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doPass("xxx");
		pop3.doQuit();
		pop3.disconnect();
	}

	public void testDoStat() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doPass("xxx");
		int[] rc = pop3.doStat();
		pop3.doQuit();
		assertNotNull(rc);
		assertTrue(rc.length==2);
		assertTrue(rc[0]<1000);
		assertTrue(rc[1]>1000);
		pop3.disconnect();
	}

	public void testDoUidl() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doPass("xxx");
		int[] stats = pop3.doStat();
		int num = stats[0];
		String[] rc2 = pop3.doUidl();
		assertNotNull(rc2);
		assertEquals(num, rc2.length);
		Log.debug("UIDL[0]="+rc2[0]);
		String uidl2Check = pop3.doUidl(0);
		Log.debug("uidl2Check="+uidl2Check);
		assertEquals(uidl2Check, rc2[0]);
		pop3.doQuit();
		pop3.disconnect();
	}

	public void testDoTop() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doPass("xxx");
		String rc = pop3.doUidl(1);
		String rc2 = pop3.doTop(1);
		Log.debug(rc2);
		Pattern DATE_Pattern=Pattern.compile("\nDate: *(.*)\n");
		String dateStr=null;
		try {
			Matcher m;
			m = DATE_Pattern.matcher(rc2);
			if (m.find()) {
				dateStr = m.group(1);
				SimpleDateFormat f = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
				Date d = f.parse(dateStr);
				Calendar cal = Calendar.getInstance();
				cal.setTime(d);
				Log.debug(""+cal.get(Calendar.YEAR)+"/"+(cal.get(Calendar.MONTH)+1)+"/"+cal.get(Calendar.DAY_OF_MONTH));
			}
		}
		catch (Exception e) {
			Log.debug("",e);
		}
		assertNotNull(dateStr);
		try {
			MimeMessage mes = new MimeMessage(null, new ByteArrayInputStream(rc2.getBytes()));
			Date d = mes.getSentDate();
			Calendar cal = Calendar.getInstance();
			cal.setTime(d);
			Log.debug(""+cal.get(Calendar.YEAR)+"/"+(cal.get(Calendar.MONTH)+1)+"/"+cal.get(Calendar.DAY_OF_MONTH));
		}
		catch (Exception e) {

		}

		try {
			HeaderDTO head = Pop3Translator.TopString2HeaderDTO(rc2, rc);
			Date d = head.getHeaderSendDate();
			Calendar cal = Calendar.getInstance();
			cal.setTime(d);
			Log.debug(""+cal.get(Calendar.YEAR)+"/"+(cal.get(Calendar.MONTH)+1)+"/"+cal.get(Calendar.DAY_OF_MONTH));
		}
		catch (Exception e) {

		}

	}

	public void testDoRetr() throws Exception
	{
		pop3.connect("mail.amax.co.jp",null);
		pop3.doUser("xxx");
		pop3.doPass("xxx");
		String rc2 = pop3.doRetr(105);
		Log.debug(rc2);
	}
}
