/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.pop3.socket;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.connectone.eai.pop3.exception.ServerCommunicationException;
import jp.co.connectone.eai.pop3.log.LogAspect;
import jp.co.connectone.eai.pop3.socket.BaseSocketImpl;
import jp.co.connectone.eai.pop3.socket.Pop3SocketCommand;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.log.Log;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class Pop3ProtocolSocketImpl
extends BaseSocketImpl {
    private String OK_Pattern = "^\\+OK.*$";
    private Pattern STAT_Pattern = Pattern.compile("^\\+OK *([0-9]*) *([0-9]*) *$");
    private Pattern UIDL_Pattern = Pattern.compile("^\\+OK *([0-9]*) *(.*) *$");
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    @Override
    protected boolean isTerminate(String line) {
        return ".".equals(line);
    }

    protected Pop3ProtocolSocketImpl() {
        this.defaultPort = 110;
    }

    public static Pop3ProtocolSocketImpl getInstance() throws HandleException {
        return new Pop3ProtocolSocketImpl();
    }

    public boolean doUser(String userId) throws HandleException {
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.USER, userId));
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on USER command transaction.", e);
        }
        return this.isOk(rc);
    }

    public boolean doPass(String passwd) throws HandleException {
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.PASS, passwd));
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on PASS command transaction.", e);
        }
        return this.isOk(rc);
    }

    public int[] doStat() throws HandleException {
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.STAT, new String[0]));
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on STAT command transaction.", e);
        }
        if (!this.isOk(rc)) {
            return null;
        }
        try {
            return this.parseStatReturn(rc);
        }
        catch (NumberFormatException e) {
            throw new HandleException("STAT command reply(" + rc + ") is number format error.", (Throwable)e);
        }
    }

    private int[] parseStatReturn(String line) throws NumberFormatException {
        int[] rc = null;
        Matcher m = this.STAT_Pattern.matcher(line);
        if (m.find()) {
            rc = new int[2];
            String number = m.group(1);
            String bytes = m.group(2);
            String string = "number=" + number + ",bytes=" + bytes;
            Pop3ProtocolSocketImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            rc[0] = Integer.parseInt(number);
            rc[1] = Integer.parseInt(bytes);
        }
        return rc;
    }

    public String doUidl(int index) throws HandleException {
        ++index;
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.UIDL, "" + index));
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on UIDL command transaction.", e);
        }
        if (!this.isOk(rc)) {
            return null;
        }
        return this.parseUidlReturn(rc);
    }

    public String parseUidlReturn(String line) {
        if (line == null) {
            return null;
        }
        String rc = null;
        Matcher m = this.UIDL_Pattern.matcher(line);
        if (m.find()) {
            rc = m.group(2);
        }
        return rc;
    }

    public String[] doUidl() throws HandleException {
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.UIDL, new String[0]), true);
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on UIDL command transaction.", e);
        }
        String[] uidls = rc.split("\n");
        if (!this.isOk(uidls[0])) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 1;
        while (i < uidls.length) {
            v.add(uidls[i].split(" ")[1]);
            ++i;
        }
        return v.toArray(new String[0]);
    }

    public String doTop(int index) throws HandleException {
        ++index;
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.TOP, "" + index, "0"), true);
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on TOP command transaction.", e);
        }
        return this.parseTopRetrLines(rc);
    }

    public String doRetr(int index) throws HandleException {
        ++index;
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.RETR, "" + index), true);
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on RETR command transaction.", e);
        }
        return this.parseTopRetrLines(rc);
    }

    public boolean doDelete(int index) throws HandleException {
        ++index;
        String rc = "";
        try {
            rc = super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.DELE, "" + index), false);
        }
        catch (IOException e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new ServerCommunicationException("error on DELETE command transaction.", e);
        }
        return this.isOk(rc);
    }

    private String parseTopRetrLines(String rc) {
        if (rc == null) {
            return null;
        }
        if (!rc.startsWith("+OK")) {
            return null;
        }
        return rc.substring(rc.indexOf("\n") + 1);
    }

    public boolean doQuit() throws HandleException {
        try {
            super.transaction(new Pop3SocketCommand(Pop3SocketCommand.CMD.QUIT, new String[0]));
        }
        catch (IOException e) {
            Log.error((String)"error on QUIT command transaction.", (Throwable)e);
        }
        return true;
    }

    protected boolean isOk(String line) {
        if (line == null) {
            return false;
        }
        boolean rc = line.matches(this.OK_Pattern);
        if (!rc) {
            String string = "pop3 returns error:" + line;
            Pop3ProtocolSocketImpl.trace_aroundBody3$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_1);
        }
        return rc;
    }

    @Override
    public void connect(String server1, String server2, int port) throws HandleException {
        super.connect(server1, server2, port);
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (SocketTimeoutException e) {
            Log.debug((String)"Socket.reading, connection timeout.", (Throwable)e);
            throw new ServerCommunicationException("error on connect timeout.", e);
        }
        catch (IOException e) {
            Log.debug((String)"Socket.reading, connect error.", (Throwable)e);
            throw new ServerCommunicationException("error on connect.", e);
        }
        if (line == null) {
            String string = "Socket.reading, returns null on connect.";
            Pop3ProtocolSocketImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
            throw new ServerCommunicationException("POP connection is not alive.");
        }
        if (!this.isOk(line)) {
            String string = "pop3 returns error on connect. " + line;
            Pop3ProtocolSocketImpl.debug_aroundBody7$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_3);
            throw new ServerCommunicationException("pop3 returns error on connect. " + line);
        }
        String string = "pop3:" + line;
        Pop3ProtocolSocketImpl.trace_aroundBody9$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_4);
    }

    @Override
    public void connect(String server1, String server2) throws HandleException {
        this.connect(server1, server2, this.defaultPort);
    }

    public static /* bridge */ /* synthetic */ BaseSocketImpl getInstance() throws HandleException {
        return Pop3ProtocolSocketImpl.getInstance();
    }

    static {
        Pop3ProtocolSocketImpl.ajc$preClinit();
    }

    private static final /* synthetic */ void debug_aroundBody0(Pop3ProtocolSocketImpl pop3ProtocolSocketImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(Pop3ProtocolSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody2(Pop3ProtocolSocketImpl pop3ProtocolSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody3$advice(Pop3ProtocolSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(Pop3ProtocolSocketImpl pop3ProtocolSocketImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(Pop3ProtocolSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody6(Pop3ProtocolSocketImpl pop3ProtocolSocketImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody7$advice(Pop3ProtocolSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void trace_aroundBody8(Pop3ProtocolSocketImpl pop3ProtocolSocketImpl, String string) {
        Log.trace((String)string);
    }

    private static final /* synthetic */ void trace_aroundBody9$advice(Pop3ProtocolSocketImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).isTraceEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_pop3_log_LogAspect$jp_co_connectone_eai_pop3_log_LogAspect$log(ajc$aspectInstance).trace((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Pop3ProtocolSocketImpl.java", Class.forName("jp.co.connectone.eai.pop3.socket.Pop3ProtocolSocketImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 92);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 216);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 238);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 242);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "trace", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 245);
    }
}

