package jp.co.connectone.webproxy.ui.logic;

import java.util.*;

import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.eai.notes.store.*;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.store.*;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.client.*;
import jp.co.connectone.user.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.webapps.struts.*;

/**
 * @author amanot
 *
 */
public class Controler
{
	public static final int COMMON_ADDRESSBOOK = 1;
	public static final int PERSONAL_ADDRESSBOOK = 2;
	public static final int FORWARD_AGREEMENT = 0;
	public static final int MIDDLE_AGREEMENT = 1;
	public static final int REAR_AGREEMENT = 2;
	public static final int LISTSIZE=50;
	public static final int MAXCHAR=5000;
	private static Controler theSingleton=null;
	private static Properties prop=null;
	private static String server="127.0.0.1";
	private Controler(){};

	protected NotesAccountData setUpServiceInfo(String strUser,String strPassword) throws Exception
	{
		NotesAccountData acc;
		NotesMailStoreImpl aEAIPop3ImplObj = new NotesMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),strUser);
		NotesServiceInfo si = (NotesServiceInfo)aEAIPop3ImplObj.getServiceInfo();
		si.setServerAddress(server);
		acc = new NotesAccountData(uid,si);
		acc.setUserID(strUser);
		acc.setPassword(strPassword);
		return acc;
	}

	public static Controler getInstance()
	{
		if (theSingleton==null) {
			theSingleton = new Controler();
		}
		if (prop==null) {
			try {
				prop = PropertyHandlerBaseImpl.getInstance().getProperties("jp.co.connectone.webproxy.ui.logic.Controler");
				server = prop.getProperty("server");
			}
			catch (Exception e) {
				// level ERROR : install or setting
				Log.fatal("",e);
			}
		}
		return theSingleton;
	}
	public boolean checkServerAccount(String id,String password)
	{
		IAccountData acc= null;
		IScheduleStore iStore = null;
		
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		try{
			iStore.getSchedulesByDate(acc, new Date());
			return true;
		} catch(NullPointerException e){
			//On the first registration
			return true;
		} catch (Exception e) {
			Log.error("",e);
			return false;
		}
	}

	public StrutsArrayList searchAddress(String id,String password,String name,int mode,int select) throws Exception
	{
		IAddressBookStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesAddressBookStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		SearchConditionCollection conds = new SearchConditionCollection();
		AddressBookSearchCondition cond;
		switch (select) {
		case FORWARD_AGREEMENT:
			cond= new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME,name);
			break;
		case MIDDLE_AGREEMENT:
			cond= new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_DISPLAYNAME,name);
			break;
		case REAR_AGREEMENT:
			cond= new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_LASTNAME,name);
			break;
		default:
			cond= new AddressBookSearchCondition(AddressBookSearchCondition.CONDITION.TYPE_FIRSTNAME,name);
			break;

		}
		ISearchDestination dest = null;
		conds.add(cond);
		switch (mode) {
		case COMMON_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
			break;
		case PERSONAL_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
			break;
		default:
			throw new IllegalArgumentException("searchAddress:unsupported mode("+mode+")");
		}
		dest.setFolder(new NotesFolderIndex("Mail Users"));
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IAddressDTO[] rc = {};
		if (name != null) {
			rc = iStore.searchAddressBook(acc,formula);
		}

		return populateList(rc);
	}

	public StrutsArrayList getMailList(String id,String password,IFolderIndex fid,Date date) throws Exception
	{
		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		if (fid==null) {
			fid = (IFolderIndex) iStore.getFolderIndexFromString(null).getOid();
		}
		ISearchDestination dest = new BasicSearchDestination(null,fid);
		IMailDTO[] mailList = (IMailDTO[])iStore.getHeadersByDate(acc,dest,date);

		return populateList(mailList);
	}

	public StrutsArrayList getSentMailList(String id,String password,IFolderIndex fid,Date date) throws Exception
	{
		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		
		if (fid==null) {
			fid = new NotesFolderIndex(NotesMailStoreImpl.DEFAULT_NOTES_SENTBOX_NAME);
		}
		ISearchDestination dest = new BasicSearchDestination(null,fid);
		IMailDTO[] mailList = (IMailDTO[])iStore.getMailsByDate(acc,dest,date);

		return populateList(mailList);
	}

	public StrutsArrayList getScheduleList(String id,String password,Date date) throws Exception
	{
		IScheduleStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		IScheduleDTO[] scheList = (IScheduleDTO[])iStore.getSchedulesByDate(acc,date);

		return populateList(scheList);
	}

	public StrutsArrayList getOtheronesScheduleList(String id,String password,IObjectIndex idToSee, Date date) throws Exception
	{

		IScheduleStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,idToSee);
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_SINGLEDATE,date);
		conds.add(cond);
		ISearchDestination dest = iStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IScheduleDTO[] scheList = iStore.searchSchedules(acc,formula);

		return populateOtherList(scheList);
	}

	protected StrutsArrayList populateList(IRecordObject[] src) throws Exception
	{
		Collection<IRecordObject> col = Arrays.asList(src);
		Iterator<IRecordObject> it = col.iterator();
		StrutsArrayList rc = new StrutsArrayList();
		Log.debug("pageSize="+LISTSIZE);
		try {
			rc.setPageSize(LISTSIZE);
		}
		catch (NumberFormatException e) {
		Log.error("warn:error at getting listsize fron user", e);
		}
		while (it.hasNext()) {
			IRecordObject o = it.next();
			if (o instanceof IMailDTO) {
				IMailDTO dto = (IMailDTO)o;
				WebMailParseHelper pdto = new WebMailParseHelper(new MailParseHelper(dto));
				o = pdto;
			}
			else if (o instanceof IScheduleDTO) {
				IScheduleDTO dto = (IScheduleDTO)o;
				WebScheduleParseHelper pdto = new WebScheduleParseHelper(new ScheduleParseHelper(dto));
				o = pdto;
			}
			else if(o instanceof NotesDJXAddressDTO) {
				NotesDJXAddressDTO dto = (NotesDJXAddressDTO)o;
				NotesDJXWebAddressParseHelper pdto = new NotesDJXWebAddressParseHelper(dto);
				o = pdto;
			}
			rc.add(o);
		}

		Log.debug("wrappedResult:size="+rc.size());
		return rc;
	}

	protected StrutsArrayList populateOtherList(IRecordObject[] src) throws Exception
	{
		Collection<IRecordObject> col = Arrays.asList(src);
		Iterator<IRecordObject> it = col.iterator();
		StrutsArrayList rc = new StrutsArrayList();
		Log.debug("pageSize="+LISTSIZE);
		try {
			rc.setPageSize(LISTSIZE);
		}
		catch (NumberFormatException e) {
			Log.error("warn:error at getting listsize fron user", e);
		}
		while (it.hasNext()) {
			NotesScheduleDTO dto = (NotesScheduleDTO)it.next();
			String s = (String)dto.getFieldSet().get("sensitivity");
			if (s.equalsIgnoreCase("0")) {
				WebScheduleParseHelper pdto = new WebScheduleParseHelper(new ScheduleParseHelper(dto));
				rc.add(pdto);
			}
		}

		Log.debug("wrappedResult:size="+rc.size());
		return rc;
	}

	public StrutsArrayList getMailFolderList(String id,String password) throws Exception
	{

		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		ISearchDestination dest = iStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);

		FolderMetadata[] folderList = iStore.getFolderList(acc,dest);
		return populateList(folderList);
	}

	public WebAddressParseHelper getAddressBookItem(String id,String password,IObjectIndex idx,int mode) throws Exception
	{

		ISearchDestination dest = null;
		IAddressBookStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesAddressBookStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		switch (mode) {
		case COMMON_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_SERVER_ADDRESSBOOK);
			break;
		case PERSONAL_ADDRESSBOOK:
			dest = iStore.getPresetDestination(acc,IAddressBookStore.DEST_TYPE_DEFAULT_ADDRESSBOOK_FOLDER);
			break;
		default:
			throw new IllegalArgumentException("getAddressBookItem:unsupported mode("+mode+")");
		}
		IAddressDTO dto = iStore.getAddressBookItem(acc,dest,idx);
		WebAddressParseHelper ph = new NotesDJXWebAddressParseHelper(dto);
		return ph;
	}

	public WebMailParseHelper getMail(String id,String password,IObjectIndex idx) throws Exception
	{

		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		IMailDTO mail = iStore.getMail(acc,null,idx);
		WebMailParseHelper ph = new WebMailParseHelper(new MailParseHelper(mail));
		ph.setBodyLength(MAXCHAR);
		return ph;
	}
	/**
	 * w肳ꂽ̃[擾
	 * @param exm
	 * @param code
	 * @param date
	 * @return
	 * @throws Exception
	 */
	public WebMailParseHelper getMail(String id,String password,Date date) throws Exception
	{

		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		ISearchDestination dest = iStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER);
		IMailDTO[] mails = iStore.getMailsByDate(acc,dest, date);
		if(mails[0]==null)return null;
		WebMailParseHelper ph = null;
		Date sentDate = null;
		for(int i=0;i<mails.length;i++){
			sentDate = mails[i].getSentDate();
			if(date.equals(sentDate)){
				ph = new WebMailParseHelper(new MailParseHelper(mails[i]));
				ph.setBodyLength(MAXCHAR);
				break;
			}
		}
		return ph;
	}

	public void delete(String id,String password,IObjectIndex idx) throws Exception
	{

		IStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesAddressBookStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}
		
		iStore.delete(acc,null,idx);
	}

/*	public WebScheduleParseHelper getOtheronesSchedule(String id,String password,IObjectIndex idToSee,IObjectIndex idx) throws Exception
	{
		Log.debug("getOtheronesSchedule:idTooSee="+idToSee+"oid="+idx+"("+idx.getIndex().toString()+")");

		IScheduleStore iStore = null;
		IAccountData acc= null;
		SearchConditionCollection conds = new SearchConditionCollection();
		ScheduleSearchCondition cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_ACCOUNTNAME,idToSee);
		conds.add(cond);
		cond = new ScheduleSearchCondition(ScheduleSearchCondition.CONDITION.TYPE_OID,idx);
		conds.add(cond);
		ISearchDestination dest = iStore.getPresetDestination(acc,IScheduleStore.DEST_TYPE_OTHERS_SCHEDULEBOX);
		SearchFormulaBaseImpl formula = new SearchFormulaBaseImpl(dest,null,conds);
		IScheduleDTO[] scheList = iStore.searchSchedules(acc,formula);
		WebScheduleParseHelper ph = new WebScheduleParseHelper(new ScheduleParseHelper(scheList[0]));
		return ph;
	}
*/
	public WebScheduleParseHelper getSchedule(String id,String password,IObjectIndex idx) throws Exception
	{

		IScheduleStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		IScheduleDTO sche = iStore.getSchedule(acc,idx);
		WebScheduleParseHelper ph = new WebScheduleParseHelper(new ScheduleParseHelper(sche));
		return ph;
	}

	public StrutsArrayList getFolderList() throws Exception
	{
		StrutsArrayList list = null;

		return list;
	}

	public void sendMail(String id,String password,IMailDTO mail) throws Exception
	{

		IMailStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesMailStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		iStore.sendMail(acc,mail);

	}

	public void saveSchedule(String id,String password,IScheduleDTO sche) throws Exception
	{

		IScheduleStore iStore = null;
		IAccountData acc= null;
		try{
			acc = setUpServiceInfo(id,password);
			iStore = new NotesScheduleStoreImpl();
		} catch (Exception e) {
			//e.Log.error("",e);
		}

		iStore.write(acc,null,sche);
	}

/*	public String getDBFileName(HttpServletRequest request, IExM exm, String CODE) throws Exception
	{
		String file = (String) request.getSession().getAttribute(CODE + "_DB");
		if (file != null) {
			return file;
		}

		String dbFile = ((NotesServiceInfo)si).getDatabase();
		request.getSession().setAttribute(CODE + "_DB", dbFile);
		return dbFile;
	}
*/}
