/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.dbInfo;

import java.util.Properties;

import jp.co.connectone.common.IPropertyHandler;
import jp.co.connectone.common.PropertyHandlerBaseImpl;
import jp.co.connectone.log.Log;

public class MSSqlDbInfo extends DbInfo
{
	private static Properties prop = null;
	static {
		try {
			IPropertyHandler handler = PropertyHandlerBaseImpl.getInstance();
			prop = handler.getProperties("jp.co.connectone.webapps.pmm.DBBasedUserDataprovider");
		}
		catch (Exception e) {
			Log.error("",e);
		}
	}

	MSSqlDbInfo()
	{
		DB_URL    = "jdbc:sqlserver://";
		DATA_PATH = prop.getProperty("server") + ":" + prop.getProperty("port") + ";DatabaseName=" + prop.getProperty("store");
		DATA_DIR  = "";
		DB_NAME   = "";

	    DB_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
	    DB_USER   = prop.getProperty("userID");
	    DB_PASS   = prop.getProperty("password");
	    DB_GETUSER_SQL_V3   = "SELECT * FROM USER_SERVICE_VIEW WHERE USERID=? AND ACTIVEFLAG=1";
	    DB_GETDEACTIVATE_USER_SQL_V3   = "SELECT * FROM USER_SERVICE_VIEW WHERE USERID=? AND ACTIVEFLAG=0";
	    DB_SERVICE_UPDATE_SQL_V3 = "UPDATE USER_SERVICE SET SERVICEID=?,SERVICEPASS=? WHERE USER_OID=? AND SERVICECODE=?";
	    DB_SERVICE_INSERT_SQL_V3 = "INSERT INTO USER_SERVICE (USER_OID,SERVICECODE,SERVICEID,SERVICEPASS) VALUES (?,?,?,?)";
	    DB_GETOID_SQL = "SELECT OID FROM USER_TABLE WHERE USERID=?";
	    DB_GETTERMID_SQL = "SELECT ID FROM TERMINAL_ID WHERE USER_OID=?";
	    DB_USER_INSERT_SQL = "INSERT INTO USER_TABLE (USERID,PASSWORD) VALUES (?,?)";
	    DB_USER_UPDATE_SQL = "UPDATE USER_TABLE SET PASSWORD=?,MAILSIGN=?,MAXCHAR=?,LISTSIZE=? WHERE USERID=?";
	    DB_USER_SETFLAG_SQL = "UPDATE USER_TABLE SET ACTIVEFLAG=? WHERE USERID=?";
	    DB_EXCH_INSERT_SQL = "INSERT INTO EXCHACCOUNT (USER_OID,EXCHID,EXCHPASS) VALUES (?,?,?)";
	    DB_TERM_INSERT_SQL = "INSERT INTO TERMINAL_ID (USER_OID,ID) VALUES (?,?)";
	    DB_EXCH_UPDATE_SQL = "UPDATE EXCHACCOUNT SET EXCHID=?,EXCHPASS=? WHERE USER_OID=?";
	    DB_TERM_UPDATE_SQL = "UPDATE TERMINAL_ID SET ID=? WHERE USER_OID=?";
	}
}
