/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.log;

public enum SubmitType {
	DEL_SUBMIT("폜","submit"),
	DEL_CANCEL("폜Ȃ","cancel"),
	MAIL_SEND("[1]M","send"),
	MAIL_TO("[]..>>","to"),
	MAIL_CC("[CC]..>>","cc"),
	MAIL_BCC("[BCC]..>>","bcc"),

	UNKNOWN("","");

	private String key;
	private String value;

	private SubmitType(String key,String value) {
		this.key=key;
		this.value=value;
	}

	@Override
	public String toString() {
		return value;
	}

	public static SubmitType get(String key) {
		for (SubmitType type : SubmitType.values()) {
			if (type.key.equals(key)) {
				return type;
			}
		}
		return UNKNOWN;
	}
}
