/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.webapps.tools;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class DateControler
{
	private Date date;
	SimpleDateFormat f;
	
	public DateControler(Date src)
	{
		f = new SimpleDateFormat("yyyyMMdd");
		date = src;
	}
	
	public DateControler(String dateStr)
	{
		if (dateStr.length()!=8) return;
		int year;
		int month;
		int dayofmonth;
		try {
			year = Integer.parseInt(dateStr.substring(0,4));
			month = Integer.parseInt(dateStr.substring(4,6))-1;
			dayofmonth = Integer.parseInt(dateStr.substring(6,8));
		}
		catch (Exception e) {
			return;
		}
		Calendar cal = Calendar.getInstance();
		cal.set(year,month,dayofmonth);
		date = cal.getTime();
	}
	
	protected String calcDateStr(int addWeek,int addDay,int weekday)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_WEEK_IN_MONTH,addWeek);
		cal.add(Calendar.DAY_OF_YEAR,addDay);
		if (weekday>=0) {
			int today=cal.get(Calendar.DAY_OF_WEEK);
			if (weekday==Calendar.SUNDAY) {
				weekday = weekday + 7;
			}
			if (today==Calendar.SUNDAY) {
				today = today + 7;
			}
			cal.add(Calendar.DAY_OF_YEAR, weekday-today);
		}
		return f.format(cal.getTime());
	}
	
	public String getNextDateStr()
	{
		return calcDateStr(0,1,-1);
	}

	public String getPrevDateStr()
	{
		return calcDateStr(0,-1,-1);
	}

	public String getPrevMonStr()
	{
		return calcDateStr(-1,0,Calendar.MONDAY);
	}
	
	public String getNextMonStr()
	{
		return calcDateStr(1,0,Calendar.MONDAY);
	}
	
	public String getCurMonStr()
	{
		return calcDateStr(0,0,Calendar.MONDAY);
	}

	public String getPrevTueStr()
	{
		return calcDateStr(-1,0,Calendar.TUESDAY);
	}
	
	public String getNextTueStr()
	{
		return calcDateStr(1,0,Calendar.TUESDAY);
	}
	
	public String getCurTueStr()
	{
		return calcDateStr(0,0,Calendar.TUESDAY);
	}

	public String getPrevWedStr()
	{
		return calcDateStr(-1,0,Calendar.WEDNESDAY);
	}
	
	public String getNextWedStr()
	{
		return calcDateStr(1,0,Calendar.WEDNESDAY);
	}
	
	public String getCurWedStr()
	{
		return calcDateStr(0,0,Calendar.WEDNESDAY);
	}

	public String getPrevThuStr()
	{
		return calcDateStr(-1,0,Calendar.THURSDAY);
	}
	
	public String getNextThuStr()
	{
		return calcDateStr(1,0,Calendar.THURSDAY);
	}
	
	public String getCurThuStr()
	{
		return calcDateStr(0,0,Calendar.THURSDAY);
	}

	public String getPrevFriStr()
	{
		return calcDateStr(-1,0,Calendar.FRIDAY);
	}
	
	public String getNextFriStr()
	{
		return calcDateStr(1,0,Calendar.FRIDAY);
	}
	
	public String getCurFriStr()
	{
		return calcDateStr(0,0,Calendar.FRIDAY);
	}

	public String getPrevSatStr()
	{
		return calcDateStr(-1,0,Calendar.SATURDAY);
	}
	
	public String getNextSatStr()
	{
		return calcDateStr(1,0,Calendar.SATURDAY);
	}
	
	public String getCurSatStr()
	{
		return calcDateStr(0,0,Calendar.SATURDAY);
	}

	public String getPrevSunStr()
	{
		return calcDateStr(-1,0,Calendar.SUNDAY);
	}
	
	public String getNextSunStr()
	{
		return calcDateStr(1,0,Calendar.SUNDAY);
	}
	
	public String getCurSunStr()
	{
		return calcDateStr(0,0,Calendar.SUNDAY);
	}

	/**
	 * @return date ߂܂B
	 */
	public Date getDate()
	{
		return date;
	}
	
	public static Date getDateFromStr(String dateStr)
	{
		int length = dateStr.length();
		int year = 0;
		int month = 0;
		int dayOfMonth = 0;
		int hour = 0;
		int minute = 0;
		int second = 0;
		if (length == 8) {
			year = Integer.parseInt(dateStr.substring(0,4));
			month = Integer.parseInt(dateStr.substring(4,6))-1;
			dayOfMonth = Integer.parseInt(dateStr.substring(6,8));
		}
		else if (length==12) {
			year = Integer.parseInt(dateStr.substring(0,4));
			month = Integer.parseInt(dateStr.substring(4,6))-1;
			dayOfMonth = Integer.parseInt(dateStr.substring(6,8));
			hour = Integer.parseInt(dateStr.substring(8,10));
			minute = Integer.parseInt(dateStr.substring(10,12));
		}
		Calendar cal = Calendar.getInstance();
		cal.set(year,month,dayOfMonth,hour,minute,second);
		
		return cal.getTime();
	}
	
	public String getTodayStr()
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		String rc = "" + cal.get(Calendar.YEAR);
		DecimalFormat f = new DecimalFormat("00");
		
		rc += f.format(cal.get(Calendar.MONTH)+1);
		rc += f.format(cal.get(Calendar.DAY_OF_MONTH));
		return rc;
	}
	
	public static String getDateStr(Date date)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		String rc = "" + cal.get(Calendar.YEAR);
		DecimalFormat f = new DecimalFormat("00");
		
		rc += f.format(cal.get(Calendar.MONTH)+1);
		rc += f.format(cal.get(Calendar.DAY_OF_MONTH));
		return rc;
	}
	
	public static String getHourStr(Date date)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		String rc = "";
		DecimalFormat f = new DecimalFormat("00");
		
		rc += f.format(cal.get(Calendar.HOUR_OF_DAY));
		rc += f.format(cal.get(Calendar.MINUTE));
		return rc;
	}
	
	public String getDateStr()
	{
		return getDateStr(date);
	}
	
	public boolean isToday()
	{
		if (getDateStr().equals(getDateStr(new Date()))) {
			Log.debug("return true");
			return true;
		}
		Log.debug("return false");
		return false;
	}
}
