/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.log;

import org.apache.commons.logging.LogFactory;

public class Log
{
	protected static final org.apache.commons.logging.Log log = LogFactory.getLog(jp.co.connectone.log.Log.class);

	private Log()
	{
	}
	
	public static void fatal(String message)
	{
		log.fatal(message);
	}
	
	public static void fatal(String message,Throwable e)
	{
		log.fatal(message,e);
	}

	public static void warn(String message)
	{
		if (log.isWarnEnabled()) log.warn(message);
	}
	
	public static void info(String message)
	{
		if (log.isInfoEnabled()) log.info(message);
	}
	
	public static void info(String message,Throwable e)
	{
		if (log.isInfoEnabled()) log.info(message,e);
	}
	
	public static void debug(String message)
	{// dummy for AspectJ weaving
	}
	
	public static void debug(String message,Throwable e)
	{
		if (log.isDebugEnabled()) {
			if (message==null) {
				message="unknown exception/error";
			}
			else if (message.length()==0) {
				message="unknown exception/error";
			}
			log.debug(message,e);
		}
	}
	
	public static void trace(String message)
	{// dummy for AspectJ weaving
	}
	
	public static void error(String message,Throwable e)
	{
		if (message==null) {
			message="unknown exception/error";
		}
		else if (message.length()==0) {
			message="unknown exception/error";
		}
		log.error(message,e);
	}
}
