/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.service;

import java.util.HashMap;

import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.InnerServiceInfo;


/**
 * @author amanot
 *
 */
public abstract class ServiceInfo extends BasicRecordObject implements InnerServiceInfo
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected	IObjectIndex	oid;
	protected	String			serviceCode;
	protected 	IStoreID		storeID;
	protected	IDatabaseIndex	dataStore;
	protected 	String			name;
	protected 	String 			serverAddress;
	protected	int				port;
	protected 	String 			serverAddress2;
	protected	int				port2;
	protected	String[]		params = new String[10];
	
	public int getPort2()
	{
		return port2;
	}
	public void setPort2(int port2)
	{
		this.port2 = port2;
	}
	public int getPort()
	{
		return port;
	}
	public void setPort(int port)
	{
		this.port = port;
	}
	public String getServerAddress2()
	{
		return serverAddress2;
	}
	public void setServerAddress2(String serverAddress2)
	{
		this.serverAddress2 = serverAddress2;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getFieldSet()
	 */
	public HashMap<String, Object> getFieldSet()
	{
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("storeID",storeID);
		map.put("name",name);
		map.put("serverAddress",serverAddress);
		return map;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#getOid()
	 */
	public IObjectIndex getOid()
	{
		return oid;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#isNew()
	 */
	public boolean isNew()
	{
		return false;
	}
	/* ( Javadoc)
	 * @see jp.co.connectone.store.IRecordObject#setFieldSet(java.util.HashMap)
	 */
	public void setFieldSet(HashMap<String, Object> h)
	{
		if (h==null) {
			storeID=null;
			name=null;
			serverAddress=null;
		}
		else {
			storeID=(IStoreID)h.get("storeID");
			name=(String)h.get("name");
			serverAddress=(String)h.get("serverAddress");
		}
	}
	protected ServiceInfo(){}
	public ServiceInfo(IStoreID storeID,String name)
	{
		this.storeID = storeID;
		this.name = name;
	}
	
	/**
	 * @return serverAddress ߂܂B
	 */
	public String getServerAddress()
	{
		return serverAddress;
	}
	/**
	 * @return storeID ߂܂B
	 */
	public IStoreID getStoreID()
	{
		return storeID;
	}
	/**
	 * @return name ߂܂B
	 */
	public String getName()
	{
		return name;
	}
	/**
	 * @param name ݒ肷 nameB
	 */
	public void setName(String name)
	{
		this.name = name;
	}
	/**
	 * @param serverAddress ݒ肷 serverAddressB
	 */
	public void setServerAddress(String serverAddress)
	{
		this.serverAddress = serverAddress;
	}
	/**
	 * @param storeID ݒ肷 storeIDB
	 */
	protected void setStoreID(IStoreID storeID)
	{
		this.storeID = storeID;
	}
	public boolean equals(Object obj)
	{
		ServiceInfo o = (ServiceInfo)obj;
		String src1 = getClass() + storeID.getStoreID()+"."+serverAddress;
		String src2 = getClass() + o.storeID.getStoreID()+"."+o.serverAddress;
		return src1.equals(src2);
	}
	public int hashCode()
	{
		String hashSource = getClass() + storeID.getStoreID()+"."+serverAddress;
		return hashSource.hashCode();
	}
	public String getServiceCode()
	{
		return serviceCode;
	}
	public void setServiceCode(String serviceCode)
	{
		this.serviceCode = serviceCode;
	}
	public IDatabaseIndex getDataStore()
	{
		return dataStore;
	}
	public void setDataStore(IDatabaseIndex dataStore)
	{
		this.dataStore = dataStore;
	}
	
	// for connector specific parameters, override these.
	public void setParam1(String param){
		params[0]=param;
	}
	
	public void setParam2(String param){
		params[1]=param;
	}
	
	public void setParam3(String param){
		params[2]=param;
	}
	
	public void setParam4(String param){
		params[3]=param;
	}
	
	public void setParam5(String param){
		params[4]=param;
	}
	
	public void setParam6(String param){
		params[5]=param;
	}
	
	public void setParam7(String param){
		params[6]=param;
	}
	
	public void setParam8(String param){
		params[7]=param;
	}
	
	public void setParam9(String param){
		params[8]=param;
	}
	
	public void setParam10(String param){
		params[9]=param;
	}
	public void setServer1(String server)
	{
		serverAddress = server;
	}
	public void setServer2(String server)
	{
		serverAddress2 = server;
	}
	
	
}
